/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.concurrency;

import java.util.concurrent.TimeUnit;
import org.jfrog.common.concurrency.ConflictGuard;
import org.jfrog.common.concurrency.ConflictsGuard;
import org.jfrog.common.concurrency.LockingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockingUtilImpl
implements LockingUtil {
    private static final Logger log = LoggerFactory.getLogger(LockingUtilImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void clusterExclusive(ConflictsGuard<T> conflictsGuard, T lockKey, Runnable task) {
        ConflictGuard lock = conflictsGuard.getLock(lockKey);
        boolean lockAcquired = false;
        try {
            lockAcquired = lock.tryToLock(0L, TimeUnit.SECONDS);
            if (lockAcquired) {
                log.debug("Lock acquired on key {}", lockKey);
                task.run();
                return;
            }
            log.debug("key '{}' is already locked.", lockKey);
        }
        catch (InterruptedException e) {
            log.error("Interrupted while waiting for lock on key '{}'.", lockKey, (Object)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.releaseLock(lockKey, lock, lockAcquired);
        }
    }

    @Override
    public <T> void unreleasableClusterExclusive(ConflictsGuard<T> conflictsGuard, T lockKey, Runnable task) {
        ConflictGuard lock = conflictsGuard.getLock(lockKey);
        try {
            boolean lockAcquired = lock.tryToLock(0L, TimeUnit.SECONDS);
            if (lockAcquired) {
                log.debug("Lock acquired on key {}", lockKey);
                task.run();
                return;
            }
            log.debug("key '{}' is already locked.", lockKey);
        }
        catch (InterruptedException e) {
            log.error("Interrupted while waiting for lock on key '{}'.", lockKey, (Object)e);
            lock.unlock();
            Thread.currentThread().interrupt();
        }
    }

    private <T> void releaseLock(T lockKey, ConflictGuard lock, boolean lockAcquired) {
        try {
            if (lockAcquired) {
                lock.unlock();
                log.debug("Lock on key '{}' released in finally block", lockKey);
            }
        }
        catch (Exception e) {
            log.error("Unable to release lock with key {}", lockKey, (Object)e);
        }
    }
}

