/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatUtils {
    private static final Logger log = LoggerFactory.getLogger(TomcatUtils.class);

    private TomcatUtils() {
    }

    public static ConnectorDetails getMainConnector(String scheme, int preferredPort, int maintenancePort) {
        Set<ConnectorDetails> connectors = TomcatUtils.getHttpConnectors();
        if (connectors.isEmpty()) {
            throw new IllegalStateException("Could not detect listening port.");
        }
        Optional<ConnectorDetails> httpConnector = connectors.stream().filter(c -> c.getScheme().equalsIgnoreCase(scheme)).filter(c -> c.getPort() == preferredPort).findFirst();
        if (httpConnector.isEmpty()) {
            log.trace("HTTP connector with preferred scheme {} and port {} not found, looking for first connector only by preferred scheme and not equals to the maintenance port {}.", new Object[]{scheme, preferredPort, maintenancePort});
            httpConnector = connectors.stream().filter(c -> c.getPort() != maintenancePort).filter(c -> c.getScheme().equalsIgnoreCase(scheme)).findFirst();
        }
        return httpConnector.orElseGet(() -> {
            log.trace("HTTP connector with preferred scheme {} not found, looking for first connector.", (Object)scheme);
            return (ConnectorDetails)connectors.iterator().next();
        });
    }

    static Set<ConnectorDetails> getHttpConnectors() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> connectors = mbs.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            return connectors.stream().map(c -> new ConnectorDetails(TomcatUtils.getSchemaAttribute(mbs, c), c.getKeyProperty("port"))).collect(Collectors.toSet());
        }
        catch (Exception e) {
            log.error("Failed to detect Tomcat connector: {}", (Object)e.getMessage());
            log.debug("Failed to detect Tomcat connector", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String getSchemaAttribute(MBeanServer mbs, ObjectName c) {
        try {
            return mbs.getAttribute(c, "scheme").toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse scheme attribute of connector: " + c);
        }
    }

    public static class ConnectorDetails {
        private String scheme;
        private int port;

        ConnectorDetails(String scheme, String port) {
            this.scheme = StringUtils.isNotBlank((CharSequence)scheme) ? scheme : "http";
            this.port = Integer.parseInt(port);
        }

        public String buildUrl(String host, String contextPath) {
            StringBuilder urlBuilder = new StringBuilder(this.getScheme()).append("://").append(host).append(":").append(this.getPort());
            if (!contextPath.startsWith("/")) {
                urlBuilder.append("/");
            }
            return urlBuilder.append(contextPath).toString();
        }

        public String getScheme() {
            return this.scheme;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectorDetails that = (ConnectorDetails)o;
            return this.port == that.port && Objects.equals(this.scheme, that.scheme);
        }

        public int hashCode() {
            return Objects.hash(this.scheme, this.port);
        }

        public String toString() {
            return "ConnectorDetails{scheme='" + this.scheme + "', port=" + this.port + "}";
        }
    }
}

