/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.jfrog.common.JsonParsingException;

abstract class MapperUtilsBase {
    private final ObjectMapper mapper;

    protected MapperUtilsBase(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Nonnull
    public String valueToString(@Nullable Object value) {
        return this.valueToString(value, false);
    }

    @Nonnull
    public String valueToString(@Nullable Object value, boolean prettyPrint) {
        return this.unchecked(() -> prettyPrint ? this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(value) : this.mapper.writeValueAsString(value));
    }

    @Nonnull
    public JsonNode valueToTree(@Nullable Object value) {
        return this.unchecked(() -> this.mapper.valueToTree(value));
    }

    @Nonnull
    public JsonNode readTree(@Nullable String value) {
        return this.unchecked(() -> this.mapper.readTree(value));
    }

    @Nonnull
    public JsonNode readTree(@Nullable File value) {
        return this.unchecked(() -> this.mapper.readTree(value));
    }

    @Nonnull
    public JsonNode readTree(@Nullable byte[] value) {
        return this.unchecked(() -> this.mapper.readTree(value));
    }

    public ObjectNode createObjectNode() {
        return this.mapper.createObjectNode();
    }

    public byte[] valueToByteArray(Object value) {
        return this.unchecked(() -> this.mapper.writeValueAsBytes(value));
    }

    public String writeValueAsString(Object value) {
        return this.unchecked(() -> this.mapper.writeValueAsString(value));
    }

    public void writeValue(File file, Object value) {
        this.unchecked(() -> {
            this.mapper.writeValue(file, value);
            return null;
        });
    }

    @Nonnull
    public <T> T readValue(@Nonnull String object, @Nonnull Class<T> clazz) {
        return (T)this.unchecked(() -> this.mapper.readValue(object, clazz));
    }

    @Nonnull
    public <T> T readValue(@Nonnull InputStream stream, @Nonnull Class<T> clazz) {
        return (T)this.unchecked(() -> this.mapper.readValue(stream, clazz));
    }

    @Nonnull
    public <T> T readValue(String json, TypeReference<T> clazz) {
        return (T)this.unchecked(() -> this.mapper.readValue(json, clazz));
    }

    @Nonnull
    public <T> T readValueRef(String json, TypeReference<T> clazz) {
        return (T)this.unchecked(() -> this.mapper.readValue(json, clazz));
    }

    @Nonnull
    public <T> T readValueRef(File file, TypeReference<T> clazz) {
        return (T)this.unchecked(() -> this.mapper.readValue(file, clazz));
    }

    @Nonnull
    public <T> T readValue(@Nonnull Reader reader, @Nonnull Class<T> clazz) {
        return (T)this.unchecked(() -> this.mapper.readValue(reader, clazz));
    }

    public <T> T clone(@Nonnull T object, @Nonnull Class<T> clazz) {
        return this.readValue(this.valueToByteArray(object), clazz);
    }

    @Nonnull
    public <T> T readValue(@Nonnull File file, @Nonnull Class<T> clazz) {
        return (T)this.unchecked(() -> this.mapper.readValue(file, clazz));
    }

    @Nonnull
    public <T> T readValue(@Nonnull URL url, @Nonnull Class<T> clazz) {
        return (T)this.unchecked(() -> this.mapper.readValue(url, clazz));
    }

    @Nonnull
    public <T> T readValue(@Nonnull byte[] bytes, @Nonnull Class<T> clazz) {
        return (T)this.unchecked(() -> this.mapper.readValue(bytes, clazz));
    }

    @Nullable
    public Long asLong(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        throw new IllegalArgumentException("Unexpected value type: " + value.getClass());
    }

    private <T> T unchecked(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new JsonParsingException(e);
        }
    }

    public String merge(String original, String additionalData) {
        Map originalMap = this.readValue(original, Map.class);
        Map additionalDataMap = this.readValue(additionalData, Map.class);
        return this.valueToString(MapperUtilsBase.merge(originalMap, additionalDataMap));
    }

    public static Map<String, Object> merge(Map<String, Object> original, Map<String, Object> additionalData) {
        HashSet<String> allKeys = new HashSet<String>(original.keySet());
        allKeys.addAll(additionalData.keySet());
        return allKeys.stream().map(key -> {
            Object prevValue = original.get(key);
            if (additionalData.containsKey(key)) {
                Object newValue = additionalData.get(key);
                if (newValue == null) {
                    return Pair.of((Object)key, null);
                }
                if (newValue instanceof Map && prevValue instanceof Map) {
                    return Pair.of((Object)key, MapperUtilsBase.merge((Map)prevValue, (Map)newValue));
                }
                return Pair.of((Object)key, newValue);
            }
            return Pair.of((Object)key, prevValue);
        }).filter(pair -> pair.getValue() != null).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    public <T> List<T> jsonStringToObjectArray(String content, Class<T> clazz) {
        return this.unchecked(() -> (List)this.mapper.readValue(content, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, clazz)));
    }
}

