/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.util.IOUtil;
import org.jfrog.common.ClockUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final String TIMESTAMP_FORMAT = "yyyyMMddHHmmss";
    public static final String TIMESTAMP_PLACEHOLDER = "${date}";
    private static final int TEMP_DIR_CREATE_ATTEMPTS = 10;
    private static final long MEGABYTE = 0x100000L;

    private FileUtils() {
    }

    public static void renameFileToTemplate(File srcFile, String nameTemplate) throws IOException {
        if (srcFile.exists()) {
            Path path = srcFile.toPath();
            String date = ClockUtils.getFormattedDateTimeNow(TIMESTAMP_FORMAT);
            String filename = nameTemplate.replaceAll(Pattern.quote(TIMESTAMP_PLACEHOLDER), date);
            Path targetPath = path.getParent().resolve(filename);
            log.debug("Renaming file '{}' to '{}'", (Object)srcFile, (Object)filename);
            Files.move(path, targetPath, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContentToRollingFile(String content, File targetFile, int maxFiles) throws IOException {
        if (maxFiles <= 0) {
            throw new IllegalArgumentException("Maximum files must be positive");
        }
        if (!targetFile.exists()) {
            Files.createDirectories(targetFile.getParentFile().toPath(), new FileAttribute[0]);
            targetFile.createNewFile();
        } else {
            File parentDir = targetFile.getParentFile();
            String fileNameWithNoExtension = FilenameUtils.removeExtension((String)targetFile.getName());
            String fileExtension = FilenameUtils.getExtension((String)targetFile.getName());
            String newTargetFileName = fileNameWithNoExtension + "." + targetFile.lastModified() + "." + fileExtension;
            String string = targetFile.getPath().intern();
            synchronized (string) {
                org.apache.commons.io.FileUtils.copyFile((File)targetFile, (File)new File(parentDir, newTargetFileName));
            }
            ArrayList existingFileList = Lists.newArrayList((Object[])parentDir.listFiles((dir, name) -> name.startsWith(fileNameWithNoExtension) && name.endsWith(fileExtension)));
            FileUtils.cleanRollingFiles(existingFileList, maxFiles);
        }
        org.apache.commons.io.FileUtils.writeStringToFile((File)targetFile, (String)content);
    }

    public static void cleanRollingFiles(List<File> files, int maxFiles) {
        if (maxFiles <= 0) {
            throw new IllegalArgumentException("Maximum files must be positive");
        }
        Collections.sort(files);
        while (files.size() > maxFiles) {
            File toRemove = files.remove(0);
            org.apache.commons.io.FileUtils.deleteQuietly((File)toRemove);
        }
    }

    public static void handleSecretFileRemovalIfExist(File absoluteFilePath) {
        if (absoluteFilePath.exists()) {
            log.info("Secret db.properties at {} detected. Overriding all other db properties and attempting to delete", (Object)absoluteFilePath.toPath());
            boolean deleted = absoluteFilePath.delete();
            if (!deleted) {
                log.error("Failed to delete Secrets file. Aborting");
                throw new RuntimeException("Failed to delete Secrets file.");
            }
            log.info("Secrets file deleted successfully");
        }
    }

    public static void writeFile(String filename, byte[] content) {
        File file = new File(filename);
        FileOutputStream fop = null;
        try {
            if (!file.exists() && file.createNewFile()) {
                fop = new FileOutputStream(file);
                fop.write(content);
                fop.flush();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot write file to temporary directory");
        }
        finally {
            IOUtil.close(fop);
        }
    }

    public static void copyInputStreamToFile(InputStream in, File file) {
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Cannot copy file input stream");
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                IOUtil.close((InputStream)in);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)out);
        IOUtil.close((InputStream)in);
    }

    public static long bytesToMB(long sizeInBytes) {
        return sizeInBytes / 0x100000L;
    }

    public static void createDirectory(File dir, boolean transitive) {
        if (!dir.exists()) {
            boolean ok;
            for (int i = 0; i < 10 && !(ok = transitive ? dir.mkdirs() : dir.mkdir()); ++i) {
            }
            if (!dir.exists()) {
                throw new IllegalStateException("Cannot create temporary directory");
            }
        }
        dir.setWritable(true);
    }

    public static void createDirectory(File dir) {
        FileUtils.createDirectory(dir, false);
    }

    public static void writeToFileAtomic(Path fileAbsolutePath, byte[] content) throws IOException {
        if (fileAbsolutePath == null || !fileAbsolutePath.isAbsolute()) {
            throw new IOException("Bad file path" + fileAbsolutePath);
        }
        Path dir = fileAbsolutePath.getParent();
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Path tempPath = Paths.get(fileAbsolutePath + ".tmp", new String[0]);
        Files.createFile(tempPath, new FileAttribute[0]);
        File tempFile = tempPath.toFile();
        Files.write(tempPath, content, new OpenOption[0]);
        tempFile.renameTo(fileAbsolutePath.toFile());
    }
}

