package org.jfrog.common.concurrency;

/**
 * @author Uriah Levy
 */
public interface LockingUtil {

    /**
     * If a lock on the lock-key is available, acquires it using the given conflicts guard, invokes the
     * task and releases the lock. If a lock is not available, returns immediately without invoking the task.
     *
     * @param conflictsGuard - the conflicts guard responsible for locking the key
     * @param lockKey        - the key to lock
     * @param task           - the task to invoke
     */
    <T> void clusterExclusive(ConflictsGuard<T> conflictsGuard, T lockKey, Runnable task);

    /**
     * If a lock on the lock-key is available, acquires it using the given conflicts guard, invokes the
     * task, but does NOT release the lock. It is the callers responsibility to release the lock through an appropriate
     * Conflicts Guard instance. If a lock is not available, returns immediately without invoking the task.
     *
     * @param conflictsGuard - the conflicts guard responsible for locking the key
     * @param lockKey        - the key to lock
     * @param task           - the task to invoke
     */
    <T> void unreleasableClusterExclusive(ConflictsGuard<T> conflictsGuard, T lockKey, Runnable task);
}
