/*
 *
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2018 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.common.concurrency;



import java.util.concurrent.TimeUnit;

/**
 * @author gidis
 */
public class JvmConflictGuard implements ConflictGuard {

    private final LockWrapper lockWrapper;

    public JvmConflictGuard(LockWrapper lockWrapper) {
        this.lockWrapper = lockWrapper;
    }

    @Override
    public boolean tryToLock(long timeout, TimeUnit timeUnit) throws InterruptedException {
        try {
            return lockWrapper.tryLock(timeout, timeUnit);
        } catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void unlock() {
        lockWrapper.unlock();
    }

    @Override
    public void forceUnlock() {
        lockWrapper.forceUnlock();
    }

    @Override
    public boolean isLocked() {
        return lockWrapper.isLocked();
    }

}
