package org.jfrog.common;

public class ArrayUtils {

    /**
     * Split Array And Get Its First Half
     *
     * @return the first half of array
     */
    public static String[] getFirstHalfOfArray(String[] originalArray) {
        if (originalArray == null || originalArray.length == 0) {
            return new String[]{};
        }
        int length = originalArray.length;

        String[] firstHalfArray = new String[(length + 1) / 2];
        System.arraycopy(originalArray, 0, firstHalfArray, 0, firstHalfArray.length);
        return firstHalfArray;
    }


    /**
     * Split Array And Get Its First Half
     *
     * @return the second half of array
     */
    public static String[] getSecondHaltOfArray(String[] originalArray) {
        if (originalArray == null || originalArray.length == 0) {
            return new String[]{};
        }
        int length = originalArray.length;
        int firstHalfLength = (length + 1) / 2;
        String[] secondHalfArray = new String[length - firstHalfLength];
        System.arraycopy(originalArray, firstHalfLength, secondHalfArray, 0, secondHalfArray.length);
        return secondHalfArray;
    }
}
