/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamSupportUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamSupportUtils.class);

    private StreamSupportUtils() {
    }

    public static void verifyStreamIsFullyRead(InputStream stream) {
        byte[] buffer = new byte[65536];
        try {
            int count = stream.read(buffer);
            while (count >= 0) {
                count = stream.read(buffer);
            }
        }
        catch (IOException e) {
            log.warn("Error occurred while trying to validate stream is fully read, reason {}", (Object)e.getMessage());
        }
    }

    public static <T> Stream<T> enumerationToStream(Enumeration<T> enumeration) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Stream.empty();
        }
        Stream<Enumeration> generate = Stream.generate(() -> enumeration);
        Stream<Enumeration> limited = StreamSupportUtils.takeWhile(generate, Enumeration::hasMoreElements);
        return limited.map(Enumeration::nextElement);
    }

    public static <T> Stream<T> autoClose(Stream<T> aStream) {
        Stream<Object> onConsume = Stream.of(null).peek(n -> aStream.close()).filter(ignore -> false);
        return Stream.of(aStream, onConsume).flatMap(i -> i);
    }

    public static <T> Stream<T> generateTillNull(Function<Integer, T> generator) {
        return StreamSupportUtils.takeWhile(Stream.iterate(0, i -> i + 1).map(generator));
    }

    public static <T> Stream<T> takeWhile(Stream<T> stream) {
        return StreamSupportUtils.takeWhile(stream, Objects::nonNull);
    }

    public static <T> Stream<T> takeWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamSupport.stream(StreamSupportUtils.takeWhile(stream.spliterator(), predicate), false);
    }

    public static <T> Spliterator<T> takeWhile(final Spliterator<T> splitr, final Predicate<? super T> predicate) {
        return new Spliterators.AbstractSpliterator<T>(splitr.estimateSize(), 0){
            boolean stillGoing;
            {
                super(est, additionalCharacteristics);
                this.stillGoing = true;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.stillGoing) {
                    boolean hadNext = splitr.tryAdvance(elem -> {
                        if (predicate.test(elem)) {
                            consumer.accept(elem);
                        } else {
                            this.stillGoing = false;
                        }
                    });
                    return hadNext && this.stillGoing;
                }
                return false;
            }
        };
    }

    public static <T> Optional<T> retryUntil(int maxRetries, Supplier<T> producer, Predicate<T> passedCond) {
        return IntStream.range(0, maxRetries).boxed().map(i -> producer.get()).filter(passedCond).limit(1L).findFirst();
    }

    public static <T> Stream<Stream<T>> chunk(Stream<T> source, int chunkSize) {
        ArrayList acc = new ArrayList(chunkSize);
        Function<Object, Stream> chunkAcc = it -> {
            acc.add(it);
            if (acc.size() >= chunkSize) {
                try {
                    Stream stream = new ArrayList(acc).stream();
                    return stream;
                }
                finally {
                    acc.clear();
                }
            }
            return null;
        };
        Stream<Stream> streamStream = source.map(chunkAcc).filter(Objects::nonNull);
        Stream<Stream> last = Stream.of(acc).filter(it -> !it.isEmpty()).map(Collection::stream);
        return Stream.of(streamStream, last).flatMap(x -> x);
    }

    public static <T> Stream<List<T>> splitToLists(Stream<T> source, int chunkSize) {
        ArrayList acc = new ArrayList(chunkSize);
        Function<Object, List> chunkAcc = it -> {
            acc.add(it);
            if (acc.size() >= chunkSize) {
                try {
                    ArrayList arrayList = new ArrayList(acc);
                    return arrayList;
                }
                finally {
                    acc.clear();
                }
            }
            return null;
        };
        Stream<List> streamStream = source.map(chunkAcc).filter(Objects::nonNull);
        Stream last = Stream.of(acc);
        return Stream.of(streamStream, last).flatMap(x -> x).filter(it -> !it.isEmpty());
    }

    public static <T> Stream<Pair<T, Long>> index(@Nonnull Stream<T> source) {
        return StreamSupportUtils.zip(source, LongStream.iterate(0L, n -> n + 1L).boxed());
    }

    public static <T, U> Stream<Pair<T, U>> zip(@Nonnull Stream<T> aStream, @Nonnull Stream<U> bStream) {
        return StreamSupportUtils.zip(aStream, bStream, Pair::of);
    }

    private static <T, U, R> Stream<R> zip(@Nonnull Stream<T> aStream, @Nonnull Stream<U> bStream, BiFunction<T, U, R> f) {
        Iterator bIterator = bStream.iterator();
        return aStream.filter(x -> bIterator.hasNext()).map(x -> f.apply(x, bIterator.next()));
    }

    @SafeVarargs
    public static <T> Stream<T> merge(Comparator<T> ahead, Stream<T> ... streams) {
        return StreamSupportUtils.mergeStreams(ahead, streams);
    }

    private static <T> Stream<T> mergeStreams(Comparator<T> ahead, @Nonnull Stream<T>[] streams) {
        BinaryOperator accumulator = (a, b) -> StreamSupportUtils.merge(a, b, ahead);
        return Arrays.stream(streams).reduce(accumulator).orElse(Stream.empty());
    }

    public static <T> Stream<T> merge(Stream<T> a, Stream<T> b, Comparator<T> ahead) {
        MergeStreamsSpliterator<T> split = new MergeStreamsSpliterator<T>(a, b, ahead);
        return StreamSupport.stream(split, false);
    }

    public static <T> Stream<T> stream(Collection<T> set) {
        return ((Collection)Optional.ofNullable(set).orElse(Collections.emptySet())).stream();
    }

    public static <K, V> Stream<Map.Entry<K, V>> mapEntriesStream(Map<K, V> map) {
        map = Optional.ofNullable(map).orElse(Collections.emptyMap());
        return StreamSupportUtils.stream(map.entrySet());
    }

    public static <K, V> Stream<Map.Entry<K, V>> multimapEntriesStream(Multimap<K, V> map) {
        map = (Multimap)Optional.ofNullable(map).orElse((Multimap<K, V>)ArrayListMultimap.create());
        return StreamSupportUtils.stream(map.entries());
    }

    private static class MergeStreamsSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Iterator<T> aIt;
        private final Iterator<T> bIt;
        private final Comparator<T> ahead;
        boolean hasA = false;
        boolean hasB = false;
        T storeA;
        T storeB;

        MergeStreamsSpliterator(Stream<T> a, Stream<T> b, Comparator<T> ahead) {
            super(Long.MAX_VALUE, 0);
            this.aIt = a.iterator();
            this.bIt = b.iterator();
            this.ahead = ahead;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (!this.hasA && this.aIt.hasNext()) {
                this.hasA = true;
                this.storeA = this.aIt.next();
            }
            if (!this.hasB && this.bIt.hasNext()) {
                this.hasB = true;
                this.storeB = this.bIt.next();
            }
            if (!this.hasA && !this.hasB) {
                return false;
            }
            if (this.hasA && this.hasB) {
                int compare = this.ahead.compare(this.storeA, this.storeB);
                if (compare <= 0) {
                    this.hasA = false;
                    action.accept(this.storeA);
                } else {
                    this.hasB = false;
                    action.accept(this.storeB);
                }
            } else if (this.hasA) {
                this.hasA = false;
                action.accept(this.storeA);
            } else {
                this.hasB = false;
                action.accept(this.storeB);
            }
            return true;
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }
}

