/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    private ResourceUtils() {
    }

    public static InputStream getResource(String path) {
        InputStream is = ResourceUtils.class.getResourceAsStream(path);
        ResourceUtils.assertResourceNotNull(path, is);
        return is;
    }

    public static File getResourceAsFile(String path) {
        try {
            URI uri = ResourceUtils.class.getResource(path).toURI();
            ResourceUtils.assertResourceNotNull(path, uri);
            return new File(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error in finding file by URI for path='" + path + "'", e);
        }
        catch (Exception e) {
            log.error("Failed to get Resource '{}' ", (Object)path, (Object)e);
            throw e;
        }
    }

    public static String getResourceAsString(String path) {
        String string;
        block8: {
            InputStream is = ResourceUtils.getResource(path);
            try {
                string = IOUtils.toString((InputStream)is, (String)"utf-8");
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to transform resource at '" + path + "'to string", e);
                }
            }
            is.close();
        }
        return string;
    }

    public static boolean resourceExists(String path) {
        return ResourceUtils.class.getResource(path) != null;
    }

    public static void copyResource(String resourcePath, File outputFile) throws IOException {
        ResourceUtils.copyResource(resourcePath, outputFile, null, null);
    }

    public static void copyResource(String resourcePath, File outputFile, Class clazz) throws IOException {
        ResourceUtils.copyResource(resourcePath, outputFile, null, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(String resourcePath, File outputFile, InputStreamManipulator manipulator, Class clazz) throws IOException {
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(FileUtils.openOutputStream((File)outputFile));
            ResourceUtils.copyResource(resourcePath, os, manipulator, clazz);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(String resourcePath, OutputStream outputStream, InputStreamManipulator manipulator, Class clazz) throws IOException {
        InputStream origInputStream = null;
        InputStream usedInputStream = null;
        try {
            origInputStream = clazz != null ? clazz.getResourceAsStream(resourcePath) : Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            ResourceUtils.assertResourceNotNull(resourcePath, origInputStream);
            if (manipulator != null) {
                InputStream mip = manipulator.manipulate(origInputStream);
                if (mip == null) {
                    throw new RuntimeException("Received a null stream from stream manipulation");
                }
                usedInputStream = mip;
            } else {
                usedInputStream = origInputStream;
            }
            IOUtils.copy((InputStream)usedInputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly(usedInputStream);
            IOUtils.closeQuietly((InputStream)origInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)usedInputStream);
        IOUtils.closeQuietly((InputStream)origInputStream);
    }

    private static void assertResourceNotNull(String resourcePath, Object resourceHandle) {
        if (resourceHandle == null) {
            throw new IllegalArgumentException("Could not find the classpath resource at: " + resourcePath + ".");
        }
    }

    public static interface InputStreamManipulator {
        public InputStream manipulate(InputStream var1) throws IOException;
    }
}

