/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    private ExceptionUtils() {
    }

    public static <T> T wrapException(Callable<T> callable) {
        return ExceptionUtils.wrapException(callable, (String)null);
    }

    public static <T, X extends RuntimeException> T wrapException(Callable<T> callable, Class<X> wrapWith) {
        return ExceptionUtils.wrapException(callable, wrapWith, null, null);
    }

    public static <T, X extends RuntimeException> T wrapException(Callable<T> callable, Class<X> wrapWith, @Nullable String err, @Nullable String context) {
        try {
            return ExceptionUtils.wrapException(callable, context);
        }
        catch (RuntimeException e) {
            RuntimeException wrapper;
            try {
                wrapper = StringUtils.isNotBlank((CharSequence)err) ? (RuntimeException)wrapWith.getDeclaredConstructor(String.class, Throwable.class).newInstance(err, e.getCause()) : (RuntimeException)wrapWith.getDeclaredConstructor(Throwable.class).newInstance(e.getCause());
            }
            catch (Exception oops) {
                log.debug("Can't use exception {} to wrap {}: ", (Object)wrapWith.getSimpleName(), (Object)e.getClass().getSimpleName());
                log.debug("", (Throwable)oops);
                wrapper = e;
            }
            throw wrapper;
        }
    }

    public static <T> T wrapException(Callable<T> callable, String context) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException((String)(StringUtils.isEmpty((CharSequence)context) ? "" : "[" + context + "]: ") + e.getMessage(), e);
        }
    }
}

