/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jfrog.common.BiDirectionalLazyCache;
import org.jfrog.common.LazyCache;
import org.jfrog.common.LazyCacheImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDirectionalLazyCacheImpl<K, V>
extends LazyCacheImpl<K, V>
implements BiDirectionalLazyCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(BiDirectionalLazyCacheImpl.class);
    private final Cache<V, K> invertedCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final Cache<V, K> invertedCacheDummy = CacheBuilder.newBuilder().maximumSize(0L).build();
    private final Function<V, K> fetchInvertedFunction;
    private final Function<List<V>, Map<V, K>> fetchManyInverted;

    public BiDirectionalLazyCacheImpl(Function<K, V> fetchFunction, Function<V, K> fetchInvertedFunction, Function<List<K>, Map<K, V>> fetchMany, Function<List<V>, Map<V, K>> fetchManyInverted, Supplier<Map<K, V>> fetchAll) {
        super(fetchFunction, fetchMany, fetchAll);
        this.fetchInvertedFunction = fetchInvertedFunction;
        this.fetchManyInverted = fetchManyInverted;
    }

    @Override
    public Optional<V> value(K lookup) {
        Optional value = super.value(lookup);
        value.ifPresent(v -> this.getInvertedCache().put(v, lookup));
        return value;
    }

    @Override
    public Optional<K> invertedValue(V lookup) {
        Object value = this.getInvertedCache().getIfPresent(lookup);
        if (value == null && (value = this.fetchInvertedFunction.apply(lookup)) != null) {
            this.getCache().put(value, lookup);
            this.getInvertedCache().put(lookup, value);
        }
        return Optional.ofNullable(value);
    }

    @Override
    public Map<K, Optional<V>> getValues(Collection<K> keys) {
        Optional values = super.getValues(keys);
        values.forEach((key, optional) -> optional.ifPresent(value -> this.getInvertedCache().put(value, key)));
        return values;
    }

    @Override
    public Map<V, Optional<K>> getInvertedValues(Collection<V> keys) {
        Map<V, K> allCached = this.getAllInverted(keys);
        List<V> missing = this.getMissingInInvertedCache(keys, allCached);
        Map<V, K> fetched = this.fetchManyInverted.apply(missing);
        this.populateInvertedCacheWithMissingElements(fetched);
        return this.getBestVersion(keys, allCached, fetched);
    }

    @Override
    public void putAll(Map<K, V> entries) {
        entries.forEach((k, v) -> {
            this.getCache().put(k, v);
            this.getInvertedCache().put(v, k);
        });
    }

    @Override
    public void limitCachingToCurrentThread() {
        this.exclusiveCacheLock.lock();
        log.debug("Thread '{}' (id: '{}') acquired lock on bi-directional cache", (Object)Thread.currentThread().getName(), (Object)Thread.currentThread().getId());
        this.invalidateAll();
        log.info("Cache disabled!");
    }

    @Override
    public void invalidateAll() {
        this.getCache().invalidateAll();
        this.getInvertedCache().invalidateAll();
    }

    @Override
    public boolean invalidate(K k) {
        log.debug("Invalidating cache entry with key '{}'", k);
        Object v = this.getCache().getIfPresent(k);
        if (v != null) {
            this.getInvertedCache().invalidate(v);
            this.getCache().invalidate(k);
        }
        return v != null;
    }

    @Override
    public void invalidate(Collection<K> keys) {
        keys.forEach(this::invalidate);
    }

    @Override
    public void removeCachingLimit(Class clazz) {
        this.invalidateAll();
        this.exclusiveCacheLock.unlock();
        log.info("Enabled cache for '{}'", (Object)clazz.getSimpleName());
    }

    @Override
    public LazyCache<K, V> prefetch() {
        this.invalidateAll();
        this.putAll((Map)this.fetchAll.get());
        return this;
    }

    private void populateInvertedCacheWithMissingElements(Map<V, K> fetched) {
        fetched.forEach((key, value) -> {
            this.getInvertedCache().put(key, value);
            this.getCache().put(value, key);
        });
    }

    private List<V> getMissingInInvertedCache(Collection<V> keys, Map<V, K> allCached) {
        return keys.stream().filter(s -> Objects.isNull(allCached.get(s))).collect(Collectors.toList());
    }

    private Map<V, K> getAllInverted(Collection<V> keys) {
        return this.getInvertedCache().getAllPresent(keys);
    }

    private Cache<V, K> getInvertedCache() {
        return this.isCacheEnabled() || this.exclusiveCacheLock.isHeldByCurrentThread() ? this.invertedCache : this.invertedCacheDummy;
    }

    public long getInvertedCacheSize() {
        return this.getInvertedCache().size();
    }
}

