/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class ArgUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private ArgUtils() {
    }

    @Nonnull
    public static String requireMatches(String value, @Nonnull Pattern pattern, String message) {
        return ArgUtils.requireSatisfies(value, v -> v != null && pattern.matcher((CharSequence)v).matches(), message);
    }

    @Nonnull
    public static String requireNonBlank(String value, String message) {
        return ArgUtils.requireSatisfies(value, StringUtils::isNotBlank, message);
    }

    public static long requirePositive(Long value, String message) {
        return ArgUtils.requireSatisfies(value, v -> v != null && v > 0L, message);
    }

    public static float requirePositive(Float value, String message) {
        return ArgUtils.requireSatisfies(value, v -> v != null && v.floatValue() > 0.0f, message).floatValue();
    }

    public static int requirePositive(Integer value, String message) {
        return ArgUtils.requireSatisfies(value, v -> v != null && v > 0, message);
    }

    public static long requireNonNegative(Long value, String message) {
        return ArgUtils.requireSatisfies(value, v -> v != null && v >= 0L, message);
    }

    public static int requireNonNegative(Integer value, String message) {
        return ArgUtils.requireSatisfies(value, v -> v != null && v >= 0, message);
    }

    public static String requireMaxLength(String value, int maxLength, String message) {
        return ArgUtils.requireSatisfies(value, v -> v == null || v.length() <= maxLength, message);
    }

    public static String requireBasicNameCharacters(String value, String message) {
        return ArgUtils.requireSatisfies(value, v -> v == null || v.matches("[-a-zA-Z0-9._ ]*"), message);
    }

    public static String requireNullOrJson(String value, String message) {
        return ArgUtils.requireSatisfies(value, ArgUtils::isNullOrJson, message);
    }

    public static boolean isNullOrJson(String str) {
        if (str == null) {
            return true;
        }
        if (str.isEmpty()) {
            return false;
        }
        try {
            return objectMapper.readTree(str).isObject();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static <T> T requireNonNull(T value, String message) {
        return (T)ArgUtils.requireSatisfies(value, Objects::nonNull, message);
    }

    public static <T> T requireExactlyOne(T[] values, Predicate<T> predicate, String message) {
        List result = Stream.of(values).filter(predicate).collect(Collectors.toList());
        if (result.size() != 1) {
            throw new IllegalArgumentException(message + " (found " + result.size() + " matching values)");
        }
        return result.get(0);
    }

    public static <V> V requireSatisfies(V value, Predicate<V> predicate, String message) {
        if (!predicate.test(value)) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    @SafeVarargs
    public static <T> T[] arrayOf(T ... values) {
        return values;
    }

    public static <T> boolean isObjectEquals(T o1, T o2, Collection<Function<T, Object>> valueExtractors) {
        return valueExtractors.stream().allMatch(extractor -> ArgUtils.areEqual(extractor.apply(o1), extractor.apply(o2)));
    }

    public static <T> boolean areEqual(T o1, T o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (!o1.getClass().equals(o2.getClass())) {
            return false;
        }
        if (o1 instanceof Collection) {
            return ((Collection)o1).containsAll((Collection)o2) && ((Collection)o2).containsAll((Collection)o1);
        }
        return o1.equals(o2);
    }

    public static <T> T requireType(Object object, Class<T> clazz, String message) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(message);
        }
        return clazz.cast(object);
    }

    public static String requireHttpHttpsUrl(String value, String message) {
        return ArgUtils.requireSatisfies(value, v -> {
            try {
                URL url = new URL(value);
                if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
                    return false;
                }
            }
            catch (MalformedURLException e) {
                return false;
            }
            return true;
        }, message);
    }
}

