package org.jfrog.common;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * Deprecated: use the system configuration instead.
 * @author Tamir Hadad
 */
@Deprecated
public class RouterUtils {

    private static final Logger log = LoggerFactory.getLogger(RouterUtils.class);
    public static final String JFROG_ROUTER_URL = "JF_ROUTER_URL";

    private RouterUtils() {

    }

    /**
     * Gets the router url from system property if not found search in env props.
     * @return router url
     */
    public static String getRouterUrl(){
        return ConfigArgUtils.getSystemPropertyOrValue(JFROG_ROUTER_URL, System.getenv(JFROG_ROUTER_URL));
    }

    /**
     *
     * @return true if router url is set false otherwise
     */
    public static boolean isWithRouter() {
        return StringUtils.isNotBlank(getRouterUrl());
    }

    /**
     *
     * @return router port, taken from url is set. return -1 in case on invalid url
     */
    public int getRouterPort() {
        try {
            URL url = new URL(getRouterUrl());
            return url.getPort();
        } catch (MalformedURLException e) {
            log.error("Failed to parse router URL {}", getRouterUrl());
            return -1;
        }
    }
}
