/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import java.util.Collection;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public abstract class PathMatcher {
    private static final Logger log = LoggerFactory.getLogger(PathMatcher.class);
    private static final AntPathMatcher antPathMatcher = new AntPathMatcher();

    private PathMatcher() {
    }

    public static boolean matches(String path, @Nullable Collection<String> includes, @Nullable Collection<String> excludes, boolean isFolder) {
        if (PathMatcher.notNullOrEmpty(excludes)) {
            for (String exclude : excludes) {
                if (!antPathMatcher.match(exclude, path)) continue;
                log.debug("excludes pattern ({}) rejected path '{}'.", (Object)exclude, (Object)path);
                return false;
            }
        }
        if (PathMatcher.notNullOrEmpty(includes)) {
            for (String include : includes) {
                if (!PathMatcher.includeMatch(path, isFolder, include)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean matches(String pattern, String path) {
        return antPathMatcher.match(pattern, path);
    }

    private static boolean includeMatch(String path, boolean useStartMatch, String include) {
        return "**/*".equals(include) || "**".equals(include) || useStartMatch && antPathMatcher.matchStart(include, path) || antPathMatcher.match(include, path);
    }

    private static boolean notNullOrEmpty(Collection<String> pattern) {
        return pattern != null && !pattern.isEmpty();
    }

    static {
        antPathMatcher.setTrimTokens(true);
    }
}

