/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.common.ArgUtils;
import org.jfrog.common.ClockUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedValue<T> {
    private static final Logger log = LoggerFactory.getLogger(CachedValue.class);
    private final Supplier<T> supplier;
    private final AtomicLong lastRefreshed = new AtomicLong(0L);
    private final AtomicLong lastRead = new AtomicLong(0L);
    private final Semaphore semaphore = new Semaphore(1);
    private volatile ValueWrapper<T> value;
    private T defaultValue;
    private Function<Runnable, Future<?>> executor = arg_0 -> ((ListeningExecutorService)MoreExecutors.newDirectExecutorService()).submit(arg_0);
    private Long expiryAfterRefresh;
    private Long expiryAfterRead;
    private long initialLoadTimeout = 0L;
    private long forceRefreshTimeout = TimeUnit.SECONDS.toMillis(10L);
    private String name;

    private CachedValue(Supplier<T> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier is required");
    }

    public T get() {
        return this.get(false);
    }

    public T get(boolean force) {
        if (this.value == null) {
            this.loadOrWait();
        } else if (this.expired() || force) {
            this.refreshOrUseCached(force);
        }
        this.lastRead.set(ClockUtils.epochMillis());
        if (this.value == null) {
            log.debug("[{}] Returning default value: {}", (Object)this.name, this.defaultValue);
            return this.defaultValue;
        }
        return this.value.getValue();
    }

    private void refreshOrUseCached(boolean force) {
        long timeout;
        log.debug("[{}] Trying to acquire semaphore in order to refresh cached value (force={}).", (Object)this.name, (Object)force);
        long l = timeout = force ? this.forceRefreshTimeout : 0L;
        if (this.tryAcquire(timeout)) {
            Future<?> future = this.assignValueAndReleaseSemaphore();
            if (timeout > 0L) {
                this.waitFor(future, timeout);
            }
        } else {
            log.debug("[{}] Semaphore was not acquired, existing cached results will be returned.", (Object)this.name);
        }
    }

    private void loadOrWait() {
        if (this.tryAcquire(this.initialLoadTimeout)) {
            log.debug("[{}] Semaphore acquired.", (Object)this.name);
            if (this.value == null) {
                log.debug("[{}] Value not yet set.", (Object)this.name);
                this.waitFor(this.assignValueAndReleaseSemaphore(), this.initialLoadTimeout);
            } else {
                this.semaphore.release();
                log.debug("[{}] Cache already set by another thread, no need to fetch it again.", (Object)this.name);
            }
        } else {
            log.debug("[{}] Semaphore was not acquired, reached timeout of {} millis.", (Object)this.name, (Object)this.initialLoadTimeout);
        }
    }

    private void waitFor(Future<?> future, long timeoutMillis) {
        try {
            future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.debug("[{}] Interrupted: {}", (Object)this.name, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            log.debug("[{}] Ignoring timeout: {}", (Object)this.name, (Object)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean tryAcquire(long timeoutMillis) {
        try {
            return this.semaphore.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.debug("[{}] Trying to acquire semaphore got interrupted.", (Object)this.name, (Object)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private Future<?> assignValueAndReleaseSemaphore() {
        return this.executor.apply(() -> {
            try {
                log.debug("[{}] Getting and caching value.", (Object)this.name);
                this.value = new ValueWrapper(this.supplier.get());
                long now = ClockUtils.epochMillis();
                this.lastRefreshed.set(now);
                this.lastRead.set(now);
            }
            finally {
                this.semaphore.release();
            }
        });
    }

    private boolean expired() {
        long now = ClockUtils.epochMillis();
        return this.expiryAfterRead != null && now - this.lastRead.longValue() > this.expiryAfterRead || this.expiryAfterRefresh != null && now - this.lastRefreshed.longValue() > this.expiryAfterRefresh;
    }

    public String toString() {
        return this.name;
    }

    public static <T> Builder<T> loadUsing(Supplier<T> supplier) {
        return new Builder<T>(supplier);
    }

    private static class ValueWrapper<T> {
        private final T value;

        private ValueWrapper(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class Builder<T> {
        private CachedValue<T> cachedValue;

        public Builder(Supplier<T> supplier) {
            this.cachedValue = new CachedValue(supplier);
        }

        public Builder<T> expireAfterRefresh(long duration, TimeUnit unit) {
            long millis = unit.toMillis(duration);
            ((CachedValue)this.cachedValue).expiryAfterRefresh = ArgUtils.requireSatisfies(millis, ms -> ms >= 0L, "expiry must be non-negative");
            return this;
        }

        Builder<T> expireAfterRead(long duration, TimeUnit unit) {
            long millis = unit.toMillis(duration);
            ((CachedValue)this.cachedValue).expiryAfterRead = ArgUtils.requireSatisfies(millis, ms -> ms >= 0L, "expiry must be non-negative");
            return this;
        }

        public Builder<T> initialLoadTimeout(long duration, TimeUnit unit) {
            long millis = unit.toMillis(duration);
            ((CachedValue)this.cachedValue).initialLoadTimeout = ArgUtils.requireSatisfies(millis, ms -> ms >= 0L, "timeout must be non-negative");
            return this;
        }

        Builder<T> forceRefreshTimeout(long duration, TimeUnit unit) {
            long millis = unit.toMillis(duration);
            ((CachedValue)this.cachedValue).forceRefreshTimeout = ArgUtils.requireSatisfies(millis, ms -> ms >= 0L, "timeout must be non-negative");
            return this;
        }

        public Builder<T> async(Function<Runnable, Future<?>> executor) {
            ((CachedValue)this.cachedValue).executor = Objects.requireNonNull(executor, "executor must be non-null");
            return this;
        }

        public Builder<T> defaultValue(T defaultValue) {
            ((CachedValue)this.cachedValue).defaultValue = defaultValue;
            return this;
        }

        public Builder<T> name(String name) {
            ((CachedValue)this.cachedValue).name = name;
            return this;
        }

        public CachedValue<T> build() {
            this.validate();
            CachedValue<T> localCachedValue = this.cachedValue;
            this.cachedValue = null;
            return localCachedValue;
        }

        private void validate() {
            if (((CachedValue)this.cachedValue).expiryAfterRefresh == null && ((CachedValue)this.cachedValue).expiryAfterRead == null) {
                throw new IllegalStateException("At least one is required: expireAfterRead / expireAfterRefresh");
            }
            if (((CachedValue)this.cachedValue).expiryAfterRefresh != null && ((CachedValue)this.cachedValue).expiryAfterRead != null) {
                throw new IllegalStateException("Only one can be used: expireAfterRead / expireAfterRefresh");
            }
            if (StringUtils.isBlank((CharSequence)((CachedValue)this.cachedValue).name)) {
                ((CachedValue)this.cachedValue).name = CachedValue.class.getSimpleName() + "@" + Integer.toHexString(this.cachedValue.hashCode());
            }
        }
    }
}

