/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.servlet;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jfrog.common.logging.logback.servlet.LoggerConfigInfo;
import org.slf4j.LoggerFactory;

public class LogbackContextSelector
implements ContextSelector {
    private final ConcurrentMap<String, LoggerContext> loggerContextsByContextId = new ConcurrentHashMap<String, LoggerContext>();
    private final LoggerContext defaultContext;
    private static final ThreadLocal<LoggerContext> tlsLoggingContext = new ThreadLocal();
    private static final ThreadLocal<LoggerConfigInfo> tlsConfigInfo = new ThreadLocal();

    public LogbackContextSelector(LoggerContext defaultContext) {
        this.defaultContext = defaultContext;
    }

    public LoggerContext getDefaultLoggerContext() {
        return this.defaultContext;
    }

    public LoggerContext detachLoggerContext(String loggerContextName) {
        return (LoggerContext)this.loggerContextsByContextId.remove(loggerContextName);
    }

    public LoggerContext getLoggerContext() {
        LoggerContext loggerContext = tlsLoggingContext.get();
        if (loggerContext != null) {
            return loggerContext;
        }
        LoggerConfigInfo configInfo = this.getConfigInfo();
        if (configInfo != null) {
            String contextId = configInfo.getContextId();
            loggerContext = (LoggerContext)this.loggerContextsByContextId.get(contextId);
            if (loggerContext == null) {
                loggerContext = new LoggerContext();
                loggerContext.setName(contextId);
                configInfo.configure(loggerContext);
                LoggerContext existingContext = this.loggerContextsByContextId.putIfAbsent(contextId, loggerContext);
                return existingContext == null ? loggerContext : existingContext;
            }
            return loggerContext;
        }
        return this.defaultContext;
    }

    public List<String> getContextNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.loggerContextsByContextId.keySet());
        return list;
    }

    public LoggerContext getLoggerContext(String name) {
        return (LoggerContext)this.loggerContextsByContextId.get(name);
    }

    public int getCount() {
        return this.loggerContextsByContextId.size();
    }

    public static void bind() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ContextSelector selector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
        if (selector instanceof LogbackContextSelector) {
            tlsLoggingContext.set(context);
        }
    }

    public static void unbind() {
        tlsLoggingContext.remove();
    }

    public static void bindConfig(LoggerConfigInfo info) {
        tlsConfigInfo.set(info);
    }

    public static void unbindConfig() {
        tlsConfigInfo.remove();
    }

    protected LoggerConfigInfo getConfigInfo() {
        return tlsConfigInfo.get();
    }
}

