/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.filters.contextaware.request;

import org.jfrog.common.logging.logback.filters.contextaware.DataRetriever;

public abstract class HttpRequestContextDataRetriver
implements DataRetriever {
    private static final String REQUEST_PREFIX = "request";
    private static final String HEADER_SECTION = "header";
    private static final String IP_SECTION = "remote_ip";

    @Override
    public Object get(String key) {
        String[] keyParts = key.split("\\.");
        if (keyParts.length < 2) {
            return null;
        }
        String prefix = keyParts[0];
        if (REQUEST_PREFIX.equals(prefix)) {
            String section = keyParts[1];
            if (section == null) {
                return null;
            }
            switch (section.toLowerCase()) {
                case "header": {
                    return this.handleHeader(keyParts[2]);
                }
                case "remote_ip": {
                    return this.handleIp();
                }
            }
        }
        return null;
    }

    protected abstract String handleIp();

    protected abstract String handleHeader(String var1);
}

