/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.audit.request;

import org.jfrog.common.ClockUtils;

public class HttpRequestLogEntry {
    private String method;
    private String path;
    private String query;
    private String requestUri;
    private String scheme;
    private String remoteAddress;
    private String username;
    private String protocol;
    private String userAgent;
    private int status;
    private Long requestContentLength;
    private Long responseContentLength;
    private Long duration;
    private Long startTime;

    public String getMethod() {
        return this.method;
    }

    public HttpRequestLogEntry method(String method) {
        this.method = method;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public HttpRequestLogEntry path(String path) {
        this.path = path;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public HttpRequestLogEntry query(String query) {
        this.query = query;
        return this;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public HttpRequestLogEntry requestUri(String requestUri) {
        this.requestUri = requestUri;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public HttpRequestLogEntry scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public HttpRequestLogEntry remoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public HttpRequestLogEntry username(String username) {
        this.username = username;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public HttpRequestLogEntry protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public HttpRequestLogEntry userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public HttpRequestLogEntry status(int status) {
        this.status = status;
        return this;
    }

    public Long getRequestContentLength() {
        return this.requestContentLength;
    }

    public HttpRequestLogEntry requestContentLength(Long contentLength) {
        this.requestContentLength = contentLength;
        return this;
    }

    public Long getResponseContentLength() {
        return this.responseContentLength;
    }

    public HttpRequestLogEntry responseContentLength(Long contentLength) {
        this.responseContentLength = contentLength;
        return this;
    }

    public Long getDuration() {
        return this.duration;
    }

    public HttpRequestLogEntry duration(Long duration) {
        this.duration = duration;
        return this;
    }

    public HttpRequestLogEntry start() {
        this.startTime = ClockUtils.epochMillis();
        return this;
    }

    public HttpRequestLogEntry stop() {
        if (this.startTime != null) {
            this.duration = ClockUtils.epochMillis() - this.startTime;
        }
        return this;
    }

    public String toString() {
        return String.join((CharSequence)" ", this.scheme, this.method, this.path, "" + this.status);
    }
}

