package org.jfrog.common.logging.slf4j;

import org.slf4j.MDC;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Yinon Avraham.
 */
public class MDCAutoRemovable implements Closeable {

    private final List<String> keys = new ArrayList<>();

    public MDCAutoRemovable put(String key, String value) {
        keys.add(key);
        MDC.put(key, value);
        return this;
    }

    @Override
    public void close() throws IOException {
        keys.forEach(MDC::remove);
    }
}
