/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.common.logging.logback.filters.contextaware.request;

import org.jfrog.common.logging.logback.filters.contextaware.BasicLogbackContext;
import org.jfrog.common.logging.logback.filters.contextaware.LogbackContext;
import org.jfrog.common.logging.logback.filters.contextaware.LogbackContextHolder;
import org.slf4j.MDC;

import javax.servlet.http.HttpServletRequest;
import java.util.UUID;

/**
 * @author haims
 */
public class RequestAwareLogbackContext extends BasicLogbackContext implements LogbackContext {

    public static final String REQUEST_ID = "request.id";

    private RequestAwareLogbackContext() {
        super(true);
    }

    public static RequestAwareLogbackContext fromRequest(HttpServletRequest request) {
        RequestAwareLogbackContext context = new RequestAwareLogbackContext();
        if (request != null) {
            context.addDataRetriever(new HttpServletRequestContextDataRetriver(request));
        }
        LogbackContextHolder.bind(context);
        MDC.put(REQUEST_ID, UUID.randomUUID().toString());
        return context;
    }

    @Override
    public void destroy() {
        LogbackContextHolder.unbind();
        MDC.remove(REQUEST_ID);
    }

}
