/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.common.logging.logback.filters.contextaware.request;

import javax.servlet.http.HttpServletRequest;

/**
 * @author haims
 */
public class HttpServletRequestContextDataRetriver extends HttpRequestContextDataRetriver {

    private final HttpServletRequest request;

    HttpServletRequestContextDataRetriver(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    protected String handleIp() {
        String remoteAddr = getRequest().getRemoteAddr();
        if (remoteAddr == null) {
            return NIL;
        }
        return remoteAddr;
    }

    private HttpServletRequest getRequest() {
        return request;
    }

    @Override
    protected String handleHeader(String headerName) {
        String header = getRequest().getHeader(headerName);
        if (header == null) {
            return NIL;
        }
        return header;
    }
}
