/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.common.logging.logback.filters.contextaware.request;

import org.jfrog.common.logging.logback.filters.contextaware.DataRetriever;

/**
 * @author haims
 */
public abstract class HttpRequestContextDataRetriver implements DataRetriever {

    private static final String REQUEST_PREFIX = "request";
    private static final String HEADER_SECTION = "header";
    private static final String IP_SECTION = "remote_ip";

    @Override
    public Object get(String key) {
        String[] keyParts = key.split("\\.");
        if (keyParts.length < 2) { return null; }
        String prefix = keyParts[0];
        if (REQUEST_PREFIX.equals(prefix)) {
            String section = keyParts[1];
            if (section == null) { return null; }
            switch (section.toLowerCase()) {
                case HEADER_SECTION:
                    return handleHeader(keyParts[2]);
                case IP_SECTION:
                    return handleIp();
            }
        }
        return null;
    }

    protected abstract String handleIp();


    protected abstract String handleHeader(String headerName);
}
