/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.common.logging.logback.filters.contextaware;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * @author haims
 */
public class LoggerMatching {

    private List<LoggerMatcher> loggerMatchers = new ArrayList<>();

    private LoggerMatching(List<LoggerMatcher> loggerMatchers) {
        this.loggerMatchers = loggerMatchers;
    }

    public LoggerMatching() {
        this(new ArrayList<>());
    }

    public boolean match(Logger logger, Level level) {

        if (loggerMatchers == null || loggerMatchers.isEmpty()) {
            return true;
        }
        // match is any loggerMatcher match
        //boolean result = matchLoggerMatcherByStream(logger, level);
        boolean result;
        for (LoggerMatcher matcher : loggerMatchers) {
            result = getLoggerMatcherResult(matcher, logger, level);
            if (result) {
                return true;
            }
        }
        return false;

    }

    /*private boolean matchLoggerMatcherByStream(Logger logger, Level level) {
        return loggerMatchers.stream().anyMatch(
                m -> getLoggerMatcherResult(m, logger, level)
        );
    }*/

    private Boolean getLoggerMatcherResult(LoggerMatcher matcher, Logger logger, Level level) {
        Boolean matcherResult = true;
        String matcherLoggerName = matcher.getLoggerName();
        String matcherLogLevel = matcher.getLogLevel();
        if (matcherLoggerName != null) {
            String currentLoggerName = logger.getName();
            matcherResult =
                    currentLoggerName.equals(matcherLoggerName) ||
                            isPackageMember(currentLoggerName, matcherLoggerName);
        }
        if (matcherLogLevel != null) {
            matcherResult = matcherResult && level.isGreaterOrEqual(Level.toLevel(matcherLogLevel));
        }
        return matcherResult;
    }

    private boolean isPackageMember(String className, String packageName) {
        return className.equals(packageName) ? true : className.startsWith(packageName + ".");
    }


    public void addLoggerMatcher(LoggerMatcher matcher) {
        this.loggerMatchers.add(matcher);
    }
}
