/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.common.logging.logback.filters.contextaware;

/**
 * @author haims
 */
public class ContextMatching {


    private ContextMatchers contextMatchers;

    public ContextMatching(ContextMatchers contextMatchers) {
        this.contextMatchers = contextMatchers;
    }

    public ContextMatching() {
        this(new ContextMatchers());
    }

    public boolean match(LogbackContext requestContext) {
        return requestContext != null && contextMatchers != null && !contextMatchers.isEmpty() &&
                matchByLoop(requestContext);
    }

    private boolean matchByLoop(LogbackContext requestContext) {
        boolean result = true;
        for (ContextMatcher matcher : contextMatchers.getContextMatchers()) {
            result = getMatcherResult(requestContext, matcher);
            if (!result) { break; }
        }
        return result;
    }

    private boolean getMatcherResult(LogbackContext requestContext, ContextMatcher matcher) {
        boolean matcherResult = false;
        String key = matcher.getKey();
        if (key != null) {
            matcherResult = stringMatch(requestContext, matcher, key);
        }
        return matcherResult;
    }


    private boolean stringMatch(LogbackContext requestContext, ContextMatcher matcher, String key) {
        boolean matcherResult;
        String contextValue = requestContext.get(key);
        String matcherValue = matcher.getValue();
        if (matcherValue != null) {
            matcherResult = matcherValue.equals(contextValue);
        } else {
            // check value for key exist in context
            matcherResult = (contextValue != null);
        }
        return matcherResult;
    }

    /*private boolean matchByStream(LogbackContext requestContext) {
        return contextMatchers.getContextMatchers().stream()
                .allMatch(matcher -> getMatcherResult(requestContext, matcher));

    }*/

    public void addFilter(String filterExpression) {
        String[] expressions = filterExpression.split("AND ");
        if (expressions.length > 0) {
            for (String exp : expressions) {
                String[] expParts = exp.trim().split("=");
                if (expParts.length <= 2 && expParts.length > 0) {
                    ContextMatcher matcher = new ContextMatcher();
                    matcher.setKey(expParts[0]);
                    if (expParts.length == 2) {
                        matcher.setValue(expParts[1]);
                    }
                    this.contextMatchers.setContextMatcher(matcher);
                }
            }
        }
    }
}
