/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.common.logging.logback.filters;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * @author haims
 */
public class InMemoryAppender<E> extends AppenderBase<E> {

    private static List<LoggingEvent> events = new CopyOnWriteArrayList<>();

    @Override
    protected void append(E e) {
        events.add((LoggingEvent) e);
    }

    public static boolean isExist(String message) {
        return events.stream().anyMatch(e -> e.getMessage().equals(message));
    }

    public static void clear() {
        events.clear();
    }
}
