/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.servlet;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import java.util.Objects;
import org.jfrog.common.logging.logback.servlet.LogbackContextSelector;
import org.jfrog.common.logging.logback.servlet.LogbackNotifier;
import org.jfrog.common.logging.logback.servlet.LogbackObserver;
import org.jfrog.common.logging.logback.servlet.LoggerConfigInfo;
import org.jfrog.common.util.FileWatchDog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackConfigManager {
    private final LoggerConfigInfo configInfo;
    private LogbackConfigWatchDog configWatchDog;
    private LoggerContext loggerContext;
    private LogbackNotifier logbackNotifier;

    public LogbackConfigManager(LoggerConfigInfo configInfo) {
        this.configInfo = Objects.requireNonNull(configInfo, "logger config info is required");
        this.logbackNotifier = new LogbackNotifier();
    }

    public void configureLogbackContext() {
        LoggerContext context;
        boolean selectorUsed = this.isSelectorUsed();
        if (selectorUsed) {
            LogbackContextSelector.bindConfig(this.configInfo);
            try {
                context = LogbackConfigManager.getOrInitLoggerContext();
            }
            finally {
                LogbackContextSelector.unbindConfig();
            }
        } else {
            context = LogbackConfigManager.getOrInitLoggerContext();
            context = this.configInfo.configure(context);
        }
        this.loggerContext = Objects.requireNonNull(context, "logger context is required");
    }

    public void startWatchDog(Long refreshInterval) {
        this.configWatchDog = new LogbackConfigWatchDog(this.loggerContext, this.configInfo);
        if (refreshInterval != null) {
            this.configWatchDog.setDelay(refreshInterval);
        }
        this.configWatchDog.start();
    }

    public void registerObserverForLogbackChange(LogbackObserver observer) {
        this.logbackNotifier.register(observer);
    }

    private static LoggerContext getOrInitLoggerContext() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    public void relaxWebComponentLogLevel() {
        try {
            LoggerContext loggerContext = LogbackConfigManager.getOrInitLoggerContext();
            loggerContext.getLogger("com.sun.jersey.spi.container.servlet.WebComponent").setLevel(Level.ERROR);
        }
        catch (Exception e) {
            System.err.println("Could not relax WebComponent log level. Continuing.");
        }
    }

    public void destroy() {
        ContextSelector selector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
        selector.detachLoggerContext(this.configInfo.getContextId());
        this.destroyWatchDog();
    }

    private void destroyWatchDog() {
        if (this.configWatchDog != null) {
            this.configWatchDog.interrupt();
            this.configWatchDog.loggerContext.stop();
        }
    }

    private boolean isSelectorUsed() {
        return System.getProperty("logback.ContextSelector") != null;
    }

    private class LogbackConfigWatchDog
    extends FileWatchDog {
        private final Logger log;
        private LoggerContext loggerContext;
        private LoggerConfigInfo configInfo;
        private final boolean selectorUsed;

        LogbackConfigWatchDog(LoggerContext loggerContext, LoggerConfigInfo configInfo) {
            super(configInfo.getLogbackConfigFile(), false);
            this.log = LoggerFactory.getLogger(LogbackConfigWatchDog.class);
            this.setName("logback-watchdog");
            this.selectorUsed = LogbackConfigManager.this.isSelectorUsed();
            this.configInfo = configInfo;
            this.loggerContext = Objects.requireNonNull(loggerContext, "logger context is required");
            this.checkAndConfigure();
        }

        @Override
        protected void doOnChange() {
            if (this.selectorUsed) {
                this.bind(this.configInfo);
            }
            try {
                this.configInfo.configure(this.loggerContext);
                LogbackConfigManager.this.logbackNotifier.runJobs();
                this.log.info("Reloaded logback config from: {}.", (Object)this.file.getAbsolutePath());
            }
            catch (Exception exception) {
            }
            finally {
                if (this.selectorUsed) {
                    this.unbind();
                }
            }
        }

        private void bind(LoggerConfigInfo configInfo) {
            LogbackContextSelector.bindConfig(configInfo);
        }

        private void unbind() {
            LogbackContextSelector.unbind();
        }
    }
}

