/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.rolling;

import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FixedWindowWithDateRollingPolicy
extends FixedWindowRollingPolicy {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final String ARCHIVE_FILE_DATE_PATTERN = "yyyy-MM-dd'T'HH-mm-ss.SSS";
    private RenameUtil renameUtil = new RenameUtil();
    private Future compressionFuture;

    public FixedWindowWithDateRollingPolicy() {
        this.setMaxIndex(10);
    }

    public void rollover() {
        this.cleanupOldFiles();
        this.renameOrCompress();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.waitForAsynchronousJobsToStop();
        super.stop();
    }

    private void cleanupOldFiles() {
        this.deleteOldestArchiveFiles(this.fileNamePatternStr, this.getMaxIndex() - this.getMinIndex());
    }

    private void renameOrCompress() {
        String targetFileName = this.getTargetFileName(this.fileNamePatternStr, this.compressionMode);
        this.renameUtil.rename(this.getActiveFileName(), targetFileName);
        if (this.compressionMode == CompressionMode.GZ) {
            this.compressionFuture = this.getCompressor().asyncCompress(targetFileName, this.patternToFileName(this.fileNamePatternStr), null);
        } else if (this.compressionMode == CompressionMode.ZIP) {
            this.compressionFuture = this.getCompressor().asyncCompress(targetFileName, this.patternToFileName(this.fileNamePatternStr), this.getZipNameEntryPattern().convert((Object)new Date()));
        }
    }

    String getTargetFileName(String pattern, CompressionMode compressionMode) {
        return CompressionMode.NONE.equals((Object)compressionMode) ? this.patternToFileName(pattern) : this.patternToFileName(pattern) + System.nanoTime() + ".tmp";
    }

    private String patternToFileName(String pattern) {
        return this.patternToFileName(pattern, this.formatDate(System.currentTimeMillis()));
    }

    String patternToFileName(String pattern, String date) {
        return pattern.replace("%i", date);
    }

    String formatDate(long time) {
        SimpleDateFormat dateFormat = this.createDateFormat();
        return dateFormat.format(time);
    }

    boolean isMyArchiveFile(String filePath, String pattern) {
        boolean beginAndEndsCorrectly;
        String[] pattenParts = pattern.split("%i");
        if (pattenParts.length != 2) {
            return false;
        }
        boolean bl = beginAndEndsCorrectly = filePath.startsWith(pattenParts[0]) && filePath.endsWith(pattenParts[1]);
        if (!beginAndEndsCorrectly) {
            return false;
        }
        String date = this.extractDatePart(filePath, pattenParts);
        if (!this.validDateLength(date)) {
            return false;
        }
        try {
            this.createDateFormat().parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    private boolean validDateLength(String date) {
        return date.length() == ARCHIVE_FILE_DATE_PATTERN.length() - 2;
    }

    private String extractDatePart(String filePath, String[] pattenParts) {
        String centralPart = StringUtils.removeStart((String)filePath, (String)pattenParts[0]);
        centralPart = StringUtils.removeEnd((String)centralPart, (String)pattenParts[1]);
        return centralPart;
    }

    void deleteOldestArchiveFiles(String pattern, int maxFilesToKeep) {
        File logDir = new File(pattern).getParentFile();
        File[] archiveFiles = logDir.listFiles(curPath -> this.isMyArchiveFile(curPath.getAbsolutePath(), pattern));
        if (archiveFiles != null && archiveFiles.length >= maxFilesToKeep) {
            Arrays.stream(archiveFiles).map(File::getAbsolutePath).sorted().limit((long)archiveFiles.length - (long)maxFilesToKeep).forEach(path -> FileUtils.deleteQuietly((File)new File((String)path)));
        }
    }

    private SimpleDateFormat createDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ARCHIVE_FILE_DATE_PATTERN);
        dateFormat.setTimeZone(UTC_TIME_ZONE);
        return dateFormat;
    }

    private Compressor getCompressor() {
        try {
            Field field = FixedWindowRollingPolicy.class.getDeclaredField("compressor");
            field.setAccessible(true);
            Object compressor = field.get((Object)this);
            field.setAccessible(false);
            return (Compressor)compressor;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Failed accessing logback compressor", e);
        }
    }

    private FileNamePattern getZipNameEntryPattern() {
        try {
            Field field = RollingPolicyBase.class.getDeclaredField("zipEntryFileNamePattern");
            field.setAccessible(true);
            Object zipPattern = field.get((Object)this);
            field.setAccessible(false);
            return (FileNamePattern)zipPattern;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Failed accessing logback zip pattern", e);
        }
    }

    void waitForAsynchronousJobsToStop() {
        if (this.compressionFuture != null) {
            try {
                this.compressionFuture.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                this.addError("Timeout while waiting for compression job to finish", e);
            }
            catch (Exception e) {
                this.addError("Unexpected exception while waiting for compression job to finish", e);
            }
        }
    }
}

