/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.filters.contextaware.request;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.MatchingFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.jfrog.common.logging.logback.filters.contextaware.ContextMatchers;
import org.jfrog.common.logging.logback.filters.contextaware.ContextMatching;
import org.jfrog.common.logging.logback.filters.contextaware.LogbackContext;
import org.jfrog.common.logging.logback.filters.contextaware.LogbackContextHolder;
import org.jfrog.common.logging.logback.filters.contextaware.LoggerMatcher;
import org.jfrog.common.logging.logback.filters.contextaware.LoggerMatching;
import org.slf4j.Marker;

public class RequestAwareLogbackFilter
extends MatchingFilter {
    private ContextMatching contextMatching = new ContextMatching();
    private LoggerMatching loggerMatching = new LoggerMatching();
    private static ThreadLocal<Boolean> inEvaluation = new ThreadLocal();

    public RequestAwareLogbackFilter() {
        this.onMatch = FilterReply.ACCEPT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        boolean initInEvaluation = false;
        FilterReply decision = FilterReply.NEUTRAL;
        try {
            if (inEvaluation == null) {
                decision = FilterReply.NEUTRAL;
            } else {
                Boolean entered = inEvaluation.get();
                if (entered == null || !entered.booleanValue()) {
                    inEvaluation.set(true);
                    initInEvaluation = true;
                    decision = this.evaluateEvent(logger, level);
                } else {
                    decision = FilterReply.NEUTRAL;
                }
            }
        }
        finally {
            if (initInEvaluation) {
                inEvaluation.set(false);
            }
        }
        return decision;
    }

    private FilterReply evaluateEvent(Logger logger, Level level) {
        try {
            boolean contextResult;
            LogbackContext requestContext = LogbackContextHolder.getContext();
            if (requestContext == null) {
                return FilterReply.NEUTRAL;
            }
            boolean loggerMatchingResult = this.loggerMatching.match(logger, level);
            if (loggerMatchingResult && (contextResult = this.contextMatching.match(requestContext))) {
                return this.onMatch;
            }
            return this.onMismatch;
        }
        catch (Exception e) {
            return FilterReply.NEUTRAL;
        }
    }

    public void setLogger(LoggerMatcher loggerMatcher) {
        this.loggerMatching.addLoggerMatcher(loggerMatcher);
    }

    public void setFilter(String filterExpression) {
        this.contextMatching.addFilter(filterExpression);
    }

    public void setContextMatchers(ContextMatchers contextMatchers) {
        this.contextMatching = new ContextMatching(contextMatchers);
    }
}

