/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.filters.contextaware.request;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.jfrog.common.logging.logback.filters.contextaware.BasicLogbackContext;
import org.jfrog.common.logging.logback.filters.contextaware.LogbackContext;
import org.jfrog.common.logging.logback.filters.contextaware.LogbackContextHolder;
import org.jfrog.common.logging.logback.filters.contextaware.request.HttpServletRequestContextDataRetriver;
import org.slf4j.MDC;

public class RequestAwareLogbackContext
extends BasicLogbackContext
implements LogbackContext {
    public static final String REQUEST_ID = "request.id";

    private RequestAwareLogbackContext() {
        super(true);
    }

    public static RequestAwareLogbackContext fromRequest(HttpServletRequest request) {
        RequestAwareLogbackContext context = new RequestAwareLogbackContext();
        if (request != null) {
            context.addDataRetriever(new HttpServletRequestContextDataRetriver(request));
        }
        LogbackContextHolder.bind(context);
        MDC.put((String)REQUEST_ID, (String)UUID.randomUUID().toString());
        return context;
    }

    @Override
    public void destroy() {
        LogbackContextHolder.unbind();
        MDC.remove((String)REQUEST_ID);
    }
}

