/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.filters.contextaware;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.ArrayList;
import java.util.List;
import org.jfrog.common.logging.logback.filters.contextaware.LoggerMatcher;

public class LoggerMatching {
    private List<LoggerMatcher> loggerMatchers = new ArrayList<LoggerMatcher>();

    private LoggerMatching(List<LoggerMatcher> loggerMatchers) {
        this.loggerMatchers = loggerMatchers;
    }

    public LoggerMatching() {
        this(new ArrayList<LoggerMatcher>());
    }

    public boolean match(Logger logger, Level level) {
        if (this.loggerMatchers == null || this.loggerMatchers.isEmpty()) {
            return true;
        }
        for (LoggerMatcher matcher : this.loggerMatchers) {
            boolean result = this.getLoggerMatcherResult(matcher, logger, level);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private Boolean getLoggerMatcherResult(LoggerMatcher matcher, Logger logger, Level level) {
        Boolean matcherResult = true;
        String matcherLoggerName = matcher.getLoggerName();
        String matcherLogLevel = matcher.getLogLevel();
        if (matcherLoggerName != null) {
            String currentLoggerName = logger.getName();
            matcherResult = currentLoggerName.equals(matcherLoggerName) || this.isPackageMember(currentLoggerName, matcherLoggerName);
        }
        if (matcherLogLevel != null) {
            matcherResult = matcherResult != false && level.isGreaterOrEqual(Level.toLevel((String)matcherLogLevel));
        }
        return matcherResult;
    }

    private boolean isPackageMember(String className, String packageName) {
        return className.equals(packageName) ? true : className.startsWith(packageName + ".");
    }

    public void addLoggerMatcher(LoggerMatcher matcher) {
        this.loggerMatchers.add(matcher);
    }
}

