/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.filters.contextaware;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jfrog.common.logging.logback.filters.contextaware.DataRetriever;
import org.jfrog.common.logging.logback.filters.contextaware.LogbackContext;

public class BasicLogbackContext
implements LogbackContext {
    private final Boolean useCache;
    private ObjectMapper mapper;
    private Map<String, Object> data = new HashMap<String, Object>();
    private Map<String, String> cachedValues = new HashMap<String, String>();
    private Map<String, Supplier<Object>> fetchers = new HashMap<String, Supplier<Object>>();
    private List<DataRetriever> retrievers = new ArrayList<DataRetriever>();
    private static final String JSON_PATH_PREFIX = "$.";
    private Map<String, JsonPath> jsonPaths = new ConcurrentHashMap<String, JsonPath>();

    public BasicLogbackContext(Boolean useCache) {
        this.useCache = useCache;
        this.mapper = new ObjectMapper();
    }

    public BasicLogbackContext() {
        this(true);
    }

    private Map getMapValue(Object value) {
        return value instanceof String ? null : (Map)this.mapper.convertValue(value, Map.class);
    }

    public void addDataRetriever(DataRetriever retriever) {
        this.retrievers.add(retriever);
    }

    public void setKeyValueFetcher(String key, Supplier<Object> supplier) {
        this.fetchers.put(key, supplier);
    }

    @Override
    public void put(String key, Object value) {
        this.data.put(key, value);
    }

    @Override
    public String get(String key) {
        if (this.useCache.booleanValue() && this.cachedValues.containsKey(key)) {
            String value = this.cachedValues.get(key);
            if (Objects.equals(value, "___n_i_l___")) {
                return null;
            }
            return value;
        }
        String value = this.findFirstMatchingKey(key, null);
        if (this.useCache.booleanValue() && value != null) {
            this.cachedValues.put(key, value);
        }
        return value;
    }

    private String findFirstMatchingKey(String key, String suffix) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        Object value = this.getExplicitValue(key);
        String calculatedValue = null;
        if (value == null) {
            int prefixIndex = key.lastIndexOf(".");
            if (prefixIndex > 0) {
                String newKey = key.substring(0, prefixIndex);
                String newSuffix = key.substring(prefixIndex + 1);
                if (!newKey.isEmpty()) {
                    calculatedValue = this.findFirstMatchingKey(newKey, newSuffix);
                }
            }
        } else if (!(value instanceof String)) {
            if (suffix != null && !suffix.isEmpty()) {
                Map mapValue = this.getMapValue(value);
                if (mapValue == null) {
                    return "___n_i_l___";
                }
                String jsonPathKey = JSON_PATH_PREFIX + suffix;
                JsonPath jsonPath = this.jsonPaths.get(jsonPathKey);
                if (jsonPath == null) {
                    jsonPath = JsonPath.compile((String)jsonPathKey, (Predicate[])new Predicate[0]);
                    this.jsonPaths.put(jsonPathKey, jsonPath);
                }
                try {
                    calculatedValue = (String)jsonPath.read((Object)mapValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (calculatedValue == null) {
                calculatedValue = "___n_i_l___";
            }
        } else {
            calculatedValue = (String)value;
        }
        return calculatedValue;
    }

    private Object getExplicitValue(String key) {
        Supplier<Object> fetcher;
        Object value = this.data.get(key);
        if (value == null && (fetcher = this.fetchers.get(key)) != null) {
            try {
                value = fetcher.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value == null) {
            for (DataRetriever retriever : this.retrievers) {
                value = retriever.get(key);
            }
        }
        return value;
    }

    @Override
    public void clear() {
        this.data.clear();
        this.fetchers.clear();
    }

    @Override
    public void remove(String key) {
        this.data.remove(key);
    }

    @Override
    public void destroy() {
    }

    public void removeFetcher(String key) {
        this.fetchers.remove(key);
    }
}

