/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.converter;

import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;

public class BackTraceLineOfCallerConverter
extends LineOfCallerConverter {
    public String convert(ILoggingEvent event) {
        String originalLoggerCallerClassName = event.getLoggerName();
        StackTraceElement[] callerData = event.getCallerData();
        if (callerData != null && callerData.length > 0) {
            for (StackTraceElement element : callerData) {
                String stackClass = element.getClassName();
                if (stackClass == null || !stackClass.startsWith(originalLoggerCallerClassName)) continue;
                return Integer.toString(element.getLineNumber());
            }
        }
        return super.convert(event);
    }
}

