/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.util;

import java.io.File;

public abstract class FileWatchDog
extends Thread {
    public static final long DEFAULT_DELAY = 30000L;
    protected long delay = 30000L;
    protected final File file;
    private long lastChanged = 0L;
    private boolean warnedAlready = false;
    private boolean interrupted = false;

    protected FileWatchDog(File file, boolean checkNow) {
        this.file = file;
        this.setDaemon(true);
        if (checkNow) {
            this.checkAndConfigure();
        } else {
            this.lastChanged = System.currentTimeMillis();
        }
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected abstract void doOnChange();

    protected void checkAndConfigure() {
        boolean fileExists;
        try {
            fileExists = this.file.exists();
        }
        catch (SecurityException e) {
            System.err.printf("Check for file existence - read denied, file: [%s].", this.file.getAbsolutePath());
            this.interrupted = true;
            return;
        }
        if (fileExists) {
            long l = this.file.lastModified();
            if (l > this.lastChanged) {
                this.lastChanged = l;
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            System.err.printf("[%s] does not exist.", this.file.getAbsolutePath());
            this.warnedAlready = true;
        }
    }

    @Override
    public void run() {
        while (!this.interrupted) {
            try {
                FileWatchDog.sleep(this.delay);
            }
            catch (InterruptedException e) {
                this.interrupted = true;
            }
            if (this.interrupted) continue;
            this.checkAndConfigure();
        }
    }
}

