/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.servlet;

import ch.qos.logback.classic.LoggerContext;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.jfrog.common.logging.logback.LogbackContextConfigurator;

public class LoggerConfigInfo
implements Serializable {
    private final String contextId;
    private final File logbackConfigFile;

    public LoggerConfigInfo(String contextId, File logbackConfigFile) {
        this.contextId = Objects.requireNonNull(StringUtils.lowerCase((String)contextId), "contextId is required");
        this.logbackConfigFile = Objects.requireNonNull(logbackConfigFile, "logback config file is required");
    }

    protected final String getContextId() {
        return this.contextId;
    }

    protected final File getLogbackConfigFile() {
        return this.logbackConfigFile;
    }

    final LoggerContext configure(LoggerContext loggerContext) {
        LogbackContextConfigurator configurator = LogbackContextConfigurator.configure(loggerContext);
        this.configure(configurator);
        configurator.configSource(this.getLogbackConfigFile());
        return configurator.build();
    }

    protected void configure(LogbackContextConfigurator configurator) {
    }

    public static String getContextId(ServletContext servletContext) {
        return StringUtils.removeStart((String)servletContext.getContextPath(), (String)"/");
    }
}

