/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jfrog.common.logging.BootstrapLogger;
import org.jfrog.common.logging.logback.servlet.LogbackConfigManager;
import org.jfrog.common.logging.logback.servlet.LoggerConfigInfo;

public abstract class LogbackConfigListenerBase
implements ServletContextListener {
    private static final String CTX_ATTR_LOGBACK_CONFIG_MANAGER = LogbackConfigListenerBase.class.getName() + ".ATTR_LOGBACK_CONFIG_MANAGER";

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        LoggerConfigInfo configInfo = this.createLoggerConfigInfo(servletContext);
        LogbackConfigManager configManager = new LogbackConfigManager(configInfo);
        servletContext.setAttribute(CTX_ATTR_LOGBACK_CONFIG_MANAGER, (Object)configManager);
        configManager.configureLogbackContext();
        configManager.startWatchDog(this.getRefreshInterval(servletContext));
        if (!this.isDevOrTest()) {
            configManager.relaxWebComponentLogLevel();
        }
    }

    private Long getRefreshInterval(ServletContext servletContext) {
        Long refreshInterval = null;
        String intervalString = servletContext.getInitParameter("logbackRefreshInterval");
        if (intervalString != null) {
            try {
                refreshInterval = Long.parseLong(intervalString);
            }
            catch (NumberFormatException e) {
                BootstrapLogger.error("Failed to parse logbackRefreshInterval. Using default log refresh interval.");
            }
        }
        return refreshInterval;
    }

    protected abstract LoggerConfigInfo createLoggerConfigInfo(ServletContext var1);

    protected boolean isDevOrTest() {
        return false;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        LogbackConfigManager configManager = (LogbackConfigManager)servletContext.getAttribute(CTX_ATTR_LOGBACK_CONFIG_MANAGER);
        if (configManager != null) {
            configManager.destroy();
        }
    }
}

