/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback.filters.contextaware;

import java.util.Iterator;
import org.jfrog.common.logging.logback.filters.contextaware.ContextMatcher;
import org.jfrog.common.logging.logback.filters.contextaware.ContextMatchers;
import org.jfrog.common.logging.logback.filters.contextaware.LogbackContext;

public class ContextMatching {
    private ContextMatchers contextMatchers;

    public ContextMatching(ContextMatchers contextMatchers) {
        this.contextMatchers = contextMatchers;
    }

    public ContextMatching() {
        this(new ContextMatchers());
    }

    public boolean match(LogbackContext requestContext) {
        return requestContext != null && this.contextMatchers != null && !this.contextMatchers.isEmpty() && this.matchByLoop(requestContext);
    }

    private boolean matchByLoop(LogbackContext requestContext) {
        ContextMatcher matcher;
        boolean result = true;
        Iterator<ContextMatcher> iterator = this.contextMatchers.getContextMatchers().iterator();
        while (iterator.hasNext() && (result = this.getMatcherResult(requestContext, matcher = iterator.next()))) {
        }
        return result;
    }

    private boolean getMatcherResult(LogbackContext requestContext, ContextMatcher matcher) {
        boolean matcherResult = false;
        String key = matcher.getKey();
        if (key != null) {
            matcherResult = this.stringMatch(requestContext, matcher, key);
        }
        return matcherResult;
    }

    private boolean stringMatch(LogbackContext requestContext, ContextMatcher matcher, String key) {
        String contextValue = requestContext.get(key);
        String matcherValue = matcher.getValue();
        boolean matcherResult = matcherValue != null ? matcherValue.equals(contextValue) : contextValue != null;
        return matcherResult;
    }

    public void addFilter(String filterExpression) {
        String[] expressions = filterExpression.split("AND ");
        if (expressions.length > 0) {
            for (String exp : expressions) {
                String[] expParts = exp.trim().split("=");
                if (expParts.length > 2 || expParts.length <= 0) continue;
                ContextMatcher matcher = new ContextMatcher();
                matcher.setKey(expParts[0]);
                if (expParts.length == 2) {
                    matcher.setValue(expParts[1]);
                }
                this.contextMatchers.setContextMatcher(matcher);
            }
        }
    }
}

