/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class LogbackContextConfigurator {
    private final LoggerContext loggerContext;
    private final JoranConfigurator joranConfigurator = new JoranConfigurator();
    private final Map<String, String> properties = new HashMap<String, String>();
    private ConfigSource configSource = ConfigSource.NULL_CONFIG_SOURCE;

    private LogbackContextConfigurator(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    public static LogbackContextConfigurator configure(LoggerContext loggerContext) {
        return new LogbackContextConfigurator(loggerContext);
    }

    public LogbackContextConfigurator property(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public LogbackContextConfigurator configSource(File file) {
        this.configSource = new ConfigSource(file);
        return this;
    }

    public LogbackContextConfigurator configSource(String filename) {
        this.configSource = new ConfigSource(filename);
        return this;
    }

    public LogbackContextConfigurator configSource(URL url) {
        this.configSource = new ConfigSource(url);
        return this;
    }

    public LogbackContextConfigurator configSource(InputStream inputStream) {
        this.configSource = new ConfigSource(inputStream);
        return this;
    }

    public LoggerContext build() {
        try {
            this.loggerContext.stop();
            this.joranConfigurator.setContext((Context)this.loggerContext);
            this.properties.forEach((arg_0, arg_1) -> ((LoggerContext)this.loggerContext).putProperty(arg_0, arg_1));
            this.configSource.configure(this.joranConfigurator);
            StatusPrinter.printIfErrorsOccured((Context)this.loggerContext);
        }
        catch (JoranException je) {
            StatusPrinter.print((Context)this.loggerContext);
        }
        return this.loggerContext;
    }

    private static class ConfigSource {
        public static final ConfigSource NULL_CONFIG_SOURCE = new ConfigSource(null, null, null, null);
        private final File file;
        private final URL url;
        private final String filename;
        private final InputStream inputStream;

        public ConfigSource(File file) {
            this(file, null, null, null);
        }

        public ConfigSource(URL url) {
            this(null, url, null, null);
        }

        public ConfigSource(String filename) {
            this(null, null, filename, null);
        }

        public ConfigSource(InputStream inputStream) {
            this(null, null, null, inputStream);
        }

        private ConfigSource(File file, URL url, String filename, InputStream inputStream) {
            this.file = file;
            this.url = url;
            this.filename = filename;
            this.inputStream = inputStream;
        }

        public void configure(JoranConfigurator configurator) throws JoranException {
            if (this.file != null) {
                configurator.doConfigure(this.file);
            } else if (this.filename != null) {
                configurator.doConfigure(this.filename);
            } else if (this.url != null) {
                configurator.doConfigure(this.url);
            } else if (this.inputStream != null) {
                configurator.doConfigure(this.inputStream);
            } else {
                throw new IllegalStateException("At least one config source is required.");
            }
        }
    }
}

