/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.logging;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;

public abstract class BootstrapLogger {
    private static File logFile;
    private static String appName;

    private BootstrapLogger() {
    }

    public static void info(String msg) {
        BootstrapLogger.log("INFO ", msg);
    }

    public static void warn(String msg) {
        BootstrapLogger.log("WARN ", msg);
    }

    public static void error(String msg) {
        BootstrapLogger.log("ERROR", msg);
    }

    private static void log(String level, String msg) {
        String logMessage = BootstrapLogger.formattedTimestamp() + " [" + appName + "] [" + level + "] " + msg;
        System.out.println(logMessage);
        BootstrapLogger.writeToFile(logMessage);
    }

    private static String formattedTimestamp() {
        return new SimpleDateFormat("YYYY-MM-dd HH:mm:ss").format(new Date());
    }

    private static void writeToFile(String logMessage) {
        if (logFile != null) {
            try {
                Files.write(logFile.toPath(), Collections.singleton(logMessage), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized void init(String applicationName, File logDir) {
        appName = applicationName;
        logFile = null;
        if (logDir != null) {
            logFile = BootstrapLogger.createNewLogFile(logDir);
        } else {
            BootstrapLogger.warn("Could not initialize bootstrap log files in directory: " + logDir);
        }
    }

    private static File createNewLogFile(File logDir) {
        File file = null;
        try {
            if ((logDir.exists() || logDir.mkdirs()) && (file = new File(logDir, appName.toLowerCase() + ".bootstrap.log")).exists() && !file.delete()) {
                BootstrapLogger.warn("Could not delete existing bootstrap log file: " + file);
            }
        }
        catch (Exception e) {
            BootstrapLogger.warn("Could not initialize bootstrap log files in directory '" + logDir + "': " + e);
        }
        if (file == null) {
            BootstrapLogger.warn("Bootstrap log file was not initialized. Logs directory: " + logDir);
        }
        return file;
    }

    public static synchronized void cleanup() {
        File file = logFile;
        logFile = null;
        BootstrapLogger.deleteFile(file);
    }

    private static void deleteFile(File file) {
        if (file != null && file.exists()) {
            try {
                if (!file.delete()) {
                    BootstrapLogger.warn("Could not delete bootstrap log file: " + file);
                }
            }
            catch (Exception e) {
                BootstrapLogger.warn("Could not delete bootstrap log file '" + file + "': " + e);
            }
        }
    }

    static {
        appName = "UNDEFINED";
    }
}

