/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.audit.request;

import org.jfrog.common.audit.request.HttpRequestLogEntry;
import org.jfrog.common.logging.slf4j.MDCAutoRemovable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger {
    private static final Logger log = LoggerFactory.getLogger(RequestLogger.class);
    private static final String UNKNOWN = "UNKNOWN";
    private static final String NON_AUTH_USER = "anonymous";
    private static final String ZERO = "0";
    private static final String DURATION_NA = "-1";
    private static final String EMPTY = "";
    private static final String ROOT = "/";
    private static final String HTTP_GET_METHOD = "GET";

    public static void log(HttpRequestLogEntry logEntry) {
        try (MDCAutoRemovable autoRemovableKeys = new MDCAutoRemovable().put("req.method", RequestLogger.valueOrDefault(logEntry.getMethod(), UNKNOWN)).put("req.path", RequestLogger.valueOrDefault(logEntry.getPath(), ROOT)).put("req.query", RequestLogger.valueOrDefault(logEntry.getQuery(), EMPTY)).put("req.uri", RequestLogger.valueOrDefault(logEntry.getRequestUri(), UNKNOWN)).put("req.scheme", RequestLogger.valueOrDefault(logEntry.getScheme(), UNKNOWN)).put("req.protocol", RequestLogger.valueOrDefault(logEntry.getProtocol(), UNKNOWN)).put("req.remoteAddress", RequestLogger.valueOrDefault(logEntry.getRemoteAddress(), UNKNOWN)).put("req.userAgent", RequestLogger.valueOrDefault(logEntry.getUserAgent(), UNKNOWN)).put("req.username", RequestLogger.valueOrDefault(logEntry.getUsername(), NON_AUTH_USER)).put("req.status", RequestLogger.positiveValueOrDefault(logEntry.getStatus(), ZERO)).put("req.contentLength", RequestLogger.valueOrDefault(logEntry.getRequestContentLength(), UNKNOWN)).put("res.contentLength", RequestLogger.valueOrDefault(logEntry.getResponseContentLength(), UNKNOWN)).put("contentLength", RequestLogger.valueOrDefault(RequestLogger.relevantContentLength(logEntry), UNKNOWN)).put("req.duration", RequestLogger.valueOrDefault(logEntry.getDuration(), DURATION_NA));){
            log.info(EMPTY);
        }
        catch (Exception e) {
            log.error("Failed to log http request entry: {}", (Object)e.toString());
            log.debug("Failed to log http request entry.", (Throwable)e);
        }
    }

    private static Long relevantContentLength(HttpRequestLogEntry logEntry) {
        return logEntry.getMethod().equalsIgnoreCase(HTTP_GET_METHOD) ? logEntry.getResponseContentLength() : logEntry.getRequestContentLength();
    }

    private static String valueOrDefault(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    private static String valueOrDefault(Long value, String defaultValue) {
        return value == null ? defaultValue : EMPTY + value;
    }

    private static String positiveValueOrDefault(int value, String defaultValue) {
        return value > 0 ? EMPTY + value : defaultValue;
    }

    private static String positiveValueOrDefault(long value, String defaultValue) {
        return value > 0L ? EMPTY + value : defaultValue;
    }

    public static boolean isEnabled() {
        return log.isInfoEnabled();
    }
}

