package org.jfrog.common.logging.logback.servlet;

import java.util.ArrayList;
import java.util.List;

/**
 * @author barh
 * Manages list of observers to notfiy when logback.xml is modified
 * Used to run jobs related to logback.xml file modification, and to enfroce certain policy.
 * example for policy: logback.xml sumologic configuration should match the configuration in the config descriptor.
 * see SumoLogicServiceImpl#registerSumologicLogbackEnforcer
 */
public class LogbackNotifier {

    private List<LogbackObserver> runOnChange;

    LogbackNotifier() {
        runOnChange = new ArrayList<>();
    }

    public void register(LogbackObserver observer) {
        runOnChange.add(observer);
    }

    public boolean isEmpty() {
        return runOnChange.isEmpty();
    }

    void runJobs() {
        runOnChange.forEach(LogbackObserver::doAction);
    }
}
