/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.common.logging.logback.filters.contextaware;

/**
 * @author haims
 */
public class LogbackContextHolder {

    private static ThreadLocal<LogbackContext> context = new ThreadLocal<>();

    public static void setContext(LogbackContext logbackFilterContext) {
        context.set(logbackFilterContext);
    }

    public static LogbackContext getContext() {
        return context.get();
    }

    public static void bind(LogbackContext logbackContext) {
        context.set(logbackContext);
    }

    public static void unbind() {
        LogbackContext logbackContext = getContext();
        if (logbackContext != null) {
            logbackContext.clear();
        }
        LogbackContextHolder.context.remove();
    }
}
