/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.common.logging.logback.filters;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/**
 * @author haims
 */
public class LoggingUtils {

    public static void updateLogbackXml(Map<String, String> replacementMap,
            String logbackFile) throws
            IOException {
        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
        try {

            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(loggerContext);
            // Call context.reset() to clear any previous configuration, e.g. default
            // configuration. For multi-step configuration, omit calling context.reset().
            loggerContext.reset();
            InputStream logbackInS = LoggingUtils.class.getClassLoader().getResourceAsStream(logbackFile);
            String logbackXml = IOUtils.toString(logbackInS);
            StrSubstitutor sub = new StrSubstitutor(replacementMap);
            String updatedLogbackXml = sub.replace(logbackXml);

            configurator.doConfigure(IOUtils.toInputStream(updatedLogbackXml));
        } catch (JoranException je) {
            // StatusPrinter will handle this
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings(loggerContext);
    }
}
