/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http;

import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class TraceIdRequestInterceptor
implements HttpRequestInterceptor {
    private final Supplier<String> traceIdSupplier;

    public TraceIdRequestInterceptor(Supplier<String> traceIdSupplier) {
        this.traceIdSupplier = traceIdSupplier;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        String traceId;
        if (!httpRequest.containsHeader("uber-trace-id") && this.traceIdSupplier != null && StringUtils.isNotBlank((String)(traceId = this.traceIdSupplier.get()))) {
            httpRequest.setHeader("uber-trace-id", traceId);
        }
    }
}

