package org.jfrog.client.http;

import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

import java.util.function.Supplier;

import static org.jfrog.common.opentracing.TraceHeaderInjectorImpl.UBER_TRACE_ID;

/**
 * Evaluates and injects the value from a Trace ID supplier.
 *
 * @author Uriah Levy
 */
public class TraceIdRequestInterceptor implements HttpRequestInterceptor {
    private final Supplier<String> traceIdSupplier;

    public TraceIdRequestInterceptor(Supplier<String> traceIdSupplier) {
        this.traceIdSupplier = traceIdSupplier;
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        if (!httpRequest.containsHeader(UBER_TRACE_ID) && traceIdSupplier != null) {
            String traceId = traceIdSupplier.get();
            if (StringUtils.isNotBlank(traceId)) {
                httpRequest.setHeader(UBER_TRACE_ID, traceId);
            }
        }
    }
}
