package org.jfrog.client.http;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * Utility class to add query parameters to a URL
 *
 * @author Yossi Shaul
 */
final class QueryParamsBuilder {
    private QueryParamsBuilder() {
        // utility class
    }

    /**
     * Adds the input parameters to the given URL and returns the result.
     *
     * @param url   The URL to add params to (may already contain other query params)
     * @param name  The parameter name
     * @param value The parameter value
     * @return The URL with the added query param
     */
    public static String param(@Nonnull String url, @Nonnull String name, @Nullable Object value) {
        String result = url;
        result += result.contains("?") ? "&" : "?";
        result += name;
        if (value != null) {
            result += "=" + encodeQueryParam(value.toString());
        }
        return result;
    }

    private static String encodeQueryParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

}
