/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http.auth;

import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;
import org.jfrog.client.http.auth.TokenProvider;

public abstract class BearerScheme
extends RFC2617Scheme {
    protected TokenProvider tokenProvider;

    public BearerScheme(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public String getSchemeName() {
        return "Bearer";
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return true;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, (HttpContext)new BasicHttpContext());
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        String token = this.getToken(credentials, request, context);
        if (StringUtils.isBlank((String)token)) {
            String req = request.getRequestLine().getMethod() + " " + request.getRequestLine().getUri();
            throw new AuthenticationException("Cannot Authenticate request " + req + ", cannot retrieve token.");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        buffer.append("Authorization");
        buffer.append(": Bearer ");
        buffer.append(token);
        return new BufferedHeader(buffer);
    }

    public abstract String getToken(Credentials var1, HttpRequest var2, HttpContext var3);
}

