/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.jfrog.client.http.RestResponse;

public class RestResponseImpl
implements RestResponse {
    private final int statusCode;
    private final byte[] body;
    private final Charset charset;

    public RestResponseImpl(int statusCode, byte[] body, Charset charset) {
        this.statusCode = statusCode;
        this.body = body == null ? null : Arrays.copyOf(body, body.length);
        this.charset = charset;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public boolean isSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    @Override
    public String getBodyAsString() {
        try {
            return this.body == null ? null : IOUtils.toString((InputStream)new ByteArrayInputStream(this.body), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create body as string from bytes (charset=" + this.charset + ")", e);
        }
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }
}

