/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http;

import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.jfrog.client.http.QueryParamsBuilder;
import org.jfrog.client.http.RestRequest;

public class HttpRequest
extends HttpEntityEnclosingRequestBase {
    public static final String X_ORIGIN_USERNAME = "X-Origin-Username";
    public static final String X_ORIGIN_USER_ADDRESS = "X-Origin-User-Address";
    private final String method;

    HttpRequest(@Nonnull String method) {
        this.method = Objects.requireNonNull(method, "method is required").toUpperCase();
    }

    public String getMethod() {
        return this.method;
    }

    public static HttpRequestBase fromRestRequest(RestRequest originalReq, String baseUrl) {
        return HttpRequest.fromRestRequest(originalReq, baseUrl, null);
    }

    public static HttpRequestBase fromRestRequest(RestRequest originalReq, String baseUrl, RequestConfig defaultRequestConfig) {
        HttpRequest httpRequest = new HttpRequest(originalReq.getMethod());
        if (originalReq.getBody() != null) {
            httpRequest.setEntity((HttpEntity)new ByteArrayEntity(originalReq.getBody()));
        }
        httpRequest.setURI(HttpRequest.createUri(originalReq, baseUrl));
        HttpRequest.setSocketTimeoutIfNeeded(originalReq, httpRequest, defaultRequestConfig);
        originalReq.getHeaders().forEach(header -> httpRequest.addHeader((String)header.getKey(), (String)header.getValue()));
        return httpRequest;
    }

    private static void setSocketTimeoutIfNeeded(RestRequest originalReq, HttpRequest httpRequest, RequestConfig defaultRequestConfig) {
        if (originalReq.getSocketTimeout() == null || originalReq.getSocketTimeout() <= 0) {
            return;
        }
        if (defaultRequestConfig == null) {
            throw new IllegalStateException("Default request config must be provided when setting different timeout");
        }
        httpRequest.setConfig(RequestConfig.copy((RequestConfig)defaultRequestConfig).setSocketTimeout(originalReq.getSocketTimeout().intValue()).build());
    }

    private static URI createUri(RestRequest originalReq, String baseUrl) {
        String uri = (HttpRequest.isFullPath(originalReq) ? "" : baseUrl + '/') + StringUtils.removeStart((String)originalReq.getPath(), (String)"/");
        for (Pair<String, String> param : originalReq.getQueryParams()) {
            uri = QueryParamsBuilder.param(uri, (String)param.getKey(), param.getValue());
        }
        return URI.create(uri);
    }

    private static boolean isFullPath(RestRequest originalReq) {
        return originalReq.getPath().matches("^https?://.*");
    }
}

