/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.jfrog.client.http.CloseableHttpClientDecorator;
import org.jfrog.client.http.CloseableHttpClientWithParamsDecorator;
import org.jfrog.client.http.TrustSelfSignedMultiChainStrategy;
import org.jfrog.client.http.auth.ProxyPreemptiveAuthInterceptor;
import org.jfrog.client.http.model.ProxyConfig;
import org.jfrog.client.util.KeyStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpBuilderBase<T extends HttpBuilderBase> {
    private static final Logger log = LoggerFactory.getLogger(HttpBuilderBase.class);
    protected HttpClientBuilder builder = HttpClients.custom();
    protected RequestConfig.Builder config = RequestConfig.custom();
    protected HttpHost defaultHost;
    protected BasicCredentialsProvider credsProvider;
    protected boolean allowAnyHostAuth;
    protected JFrogAuthScheme chosenAuthScheme = JFrogAuthScheme.BASIC;
    protected boolean cookieSupportEnabled = false;
    protected String proxyHost;
    private KeyStoreProvider keyStoreProvider;
    private KeyStoreProvider clientCertKeyStoreProvider;
    private String clientCertAlias;
    private boolean trustSelfSignCert = false;
    protected SSLContextBuilder sslContextBuilder;
    private boolean noHostVerification = false;
    protected int maxConnectionsTotal = 50;
    protected int maxConnectionsPerRoute = 50;
    private int connectionPoolTimeToLive = 30;
    private RequestConfig defaultRequestConfig;
    public static final int CONNECTION_POOL_TIME_TO_LIVE = 30;
    private static final int DEFAULT_MAX_CONNECTIONS = 50;

    public HttpBuilderBase() {
        this.credsProvider = new BasicCredentialsProvider();
        this.config.setMaxRedirects(20);
    }

    public CloseableHttpClient build() {
        return this.build(false);
    }

    public CloseableHttpClient build(boolean withParams) {
        if (this.defaultHost != null) {
            this.builder.setRoutePlanner((HttpRoutePlanner)new DefaultHostRoutePlanner(this.defaultHost));
        }
        PoolingHttpClientConnectionManager connectionMgr = this.configConnectionManager();
        if (withParams) {
            return new CloseableHttpClientWithParamsDecorator(this.builder.build(), connectionMgr, this.chosenAuthScheme == JFrogAuthScheme.SPNEGO, this.defaultRequestConfig);
        }
        return new CloseableHttpClientDecorator(this.builder.build(), connectionMgr, this.chosenAuthScheme == JFrogAuthScheme.SPNEGO, this.defaultRequestConfig);
    }

    private T self() {
        return (T)this;
    }

    public T userAgent(String userAgent) {
        this.builder.setUserAgent(userAgent);
        return this.self();
    }

    public T disableGzipResponse() {
        this.builder.disableContentCompression();
        return this.self();
    }

    public T host(String host) {
        return this.host(host, 80);
    }

    public T host(String host, int port) {
        String scheme = port != 443 ? "http" : "https";
        return this.host(host, port, scheme);
    }

    public T host(String host, int port, String scheme) {
        this.defaultHost = StringUtils.isNotBlank((String)host) ? new HttpHost(host, port, scheme) : null;
        return this.self();
    }

    public T hostFromUrl(String urlStr) {
        if (StringUtils.isNotBlank((String)urlStr)) {
            try {
                URL url = new URL(urlStr);
                this.defaultHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Cannot parse the url " + urlStr, e);
            }
        } else {
            this.defaultHost = null;
        }
        return this.self();
    }

    public T maxConnectionsPerRoute(int maxConnectionsPerHost) {
        this.maxConnectionsPerRoute = maxConnectionsPerHost;
        return this.self();
    }

    public T maxTotalConnections(int maxTotalConnections) {
        this.maxConnectionsTotal = maxTotalConnections;
        return this.self();
    }

    public T connectionTimeout(int connectionTimeout) {
        this.config.setConnectTimeout(connectionTimeout);
        return this.self();
    }

    public T socketTimeout(int soTimeout) {
        this.config.setSocketTimeout(soTimeout);
        return this.self();
    }

    public T staleCheckingEnabled(boolean staleCheckingEnabled) {
        this.config.setStaleConnectionCheckEnabled(staleCheckingEnabled);
        return this.self();
    }

    public T noRetry() {
        return this.retry(0, false);
    }

    public T retry(int retryCount) {
        return this.retry(retryCount, false);
    }

    public T retry(int retryCount, boolean requestSentRetryEnabled) {
        if (retryCount == 0) {
            this.builder.disableAutomaticRetries();
        } else {
            this.builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retryCount, requestSentRetryEnabled));
        }
        return this.self();
    }

    public T localAddress(String localAddress) {
        if (StringUtils.isNotBlank((String)localAddress)) {
            try {
                InetAddress address = InetAddress.getByName(localAddress);
                this.config.setLocalAddress(address);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid local address: " + localAddress, e);
            }
        }
        return this.self();
    }

    public T connectionPoolTTL(int seconds) {
        this.connectionPoolTimeToLive = seconds;
        return this.self();
    }

    public T enableCookieManagement(boolean enableCookieManagement) {
        if (enableCookieManagement) {
            this.config.setCookieSpec("compatibility");
        } else {
            this.config.setCookieSpec(null);
        }
        this.cookieSupportEnabled = enableCookieManagement;
        return this.self();
    }

    public T keyStoreProvider(KeyStoreProvider keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
        return this.self();
    }

    public T clientCertKeyStoreProvider(KeyStoreProvider keyStoreProvider) {
        this.clientCertKeyStoreProvider = keyStoreProvider;
        return this.self();
    }

    public T clientCertAlias(String clientCertAliasName) {
        this.clientCertAlias = clientCertAliasName;
        return this.self();
    }

    public T useKerberos(boolean useKerberos) {
        if (useKerberos) {
            Credentials use_jaas_creds = new Credentials(){

                public String getPassword() {
                    return null;
                }

                public Principal getUserPrincipal() {
                    return null;
                }
            };
            BasicCredentialsProvider credsProvider1 = new BasicCredentialsProvider();
            credsProvider1.setCredentials(new AuthScope(null, -1, null), use_jaas_creds);
            Registry spnegoScheme = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build();
            this.builder.setDefaultAuthSchemeRegistry((Lookup)spnegoScheme).setDefaultCredentialsProvider((CredentialsProvider)credsProvider1);
            this.chosenAuthScheme = JFrogAuthScheme.SPNEGO;
        }
        return this.self();
    }

    public T trustSelfSignCert(boolean trustSelfSignCert) {
        this.trustSelfSignCert = trustSelfSignCert;
        return this.self();
    }

    public T sslContextBuilder(SSLContextBuilder sslContextBuilder) {
        this.sslContextBuilder = sslContextBuilder;
        return this.self();
    }

    public T noHostVerification(boolean noHostVerification) {
        this.noHostVerification = noHostVerification;
        return this.self();
    }

    public T authentication(UsernamePasswordCredentials creds) {
        if (creds != null) {
            this.authentication(creds.getUserName(), creds.getPassword());
        }
        return this.self();
    }

    public T authentication(String username, String password) {
        return this.authentication(username, password, false);
    }

    public T authentication(String username, String password, boolean allowAnyHost, List<String> additionalAuthScopes) {
        if (StringUtils.isNotBlank((String)username)) {
            if (this.defaultHost == null || StringUtils.isBlank((String)this.defaultHost.getHostName())) {
                throw new IllegalStateException("Cannot configure authentication when host is not set.");
            }
            this.allowAnyHostAuth = allowAnyHost;
            AuthScope authscope = allowAnyHost ? new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM) : new AuthScope(this.defaultHost.getHostName(), -1, AuthScope.ANY_REALM);
            this.credsProvider.setCredentials(authscope, (Credentials)new UsernamePasswordCredentials(username, password));
            if (additionalAuthScopes != null) {
                additionalAuthScopes.forEach(scope -> this.credsProvider.setCredentials(new AuthScope(scope, -1, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(username, password)));
            }
        }
        return this.self();
    }

    public T authentication(String username, String password, boolean allowAnyHost) {
        return this.authentication(username, password, allowAnyHost, null);
    }

    public T addRequestInterceptor(HttpRequestInterceptor interceptor) {
        this.builder.addInterceptorFirst(interceptor);
        return this.self();
    }

    public T addResponseInterceptor(HttpResponseInterceptor interceptor) {
        this.builder.addInterceptorLast(interceptor);
        return this.self();
    }

    public T redirectStrategy(RedirectStrategy redirectStrategy) {
        this.builder.setRedirectStrategy(redirectStrategy);
        return this.self();
    }

    public T proxy(ProxyConfig proxy) {
        if (proxy == null) {
            return this.self();
        }
        this.proxyHost = proxy.getHost();
        ProxyConfigBuilder proxyBuilder = this.proxy(proxy.getHost(), proxy.getPort());
        if (StringUtils.isNotBlank((String)proxy.getUsername())) {
            if (proxy.getDomain() == null) {
                proxyBuilder.authentication(proxy.getUsername(), proxy.getPassword());
            } else {
                try {
                    String ntHost = StringUtils.isBlank((String)proxy.getNtHost()) ? InetAddress.getLocalHost().getHostName() : proxy.getNtHost();
                    proxyBuilder.ntlmAuthentication(proxy.getUsername(), proxy.getPassword(), ntHost, proxy.getDomain());
                }
                catch (UnknownHostException e) {
                    log.error("Failed to determine required local hostname for NTLM credentials.", (Throwable)e);
                }
            }
            proxyBuilder.redirectToHostProxies(proxy.getRedirectedToHostsList());
        }
        return this.self();
    }

    public ProxyConfigBuilder proxy(String host, int port) {
        return new ProxyConfigBuilder(host, port);
    }

    public boolean isCookieSupportEnabled() {
        return this.cookieSupportEnabled;
    }

    public static ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
        return (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return 30000L;
        };
    }

    public RequestConfig getDefaultRequestConfig() {
        return this.defaultRequestConfig;
    }

    protected PoolingHttpClientConnectionManager configConnectionManager() {
        if (!this.isCookieSupportEnabled()) {
            this.builder.disableCookieManagement();
        }
        if (this.hasCredentials()) {
            this.builder.setDefaultCredentialsProvider((CredentialsProvider)this.credsProvider);
        }
        this.defaultRequestConfig = this.config.build();
        this.builder.setDefaultRequestConfig(this.defaultRequestConfig);
        this.builder.setKeepAliveStrategy(HttpBuilderBase.createConnectionKeepAliveStrategy());
        this.builder.setMaxConnTotal(this.maxConnectionsTotal);
        this.builder.setMaxConnPerRoute(this.maxConnectionsPerRoute);
        PoolingHttpClientConnectionManager connectionMgr = this.createConnectionMgr();
        this.builder.setConnectionManager((HttpClientConnectionManager)connectionMgr);
        return connectionMgr;
    }

    private PoolingHttpClientConnectionManager createConnectionMgr() {
        SSLContext sslContext = this.buildSslContext();
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)(this.noHostVerification ? NoopHostnameVerifier.INSTANCE : new DefaultHostnameVerifier()));
        Registry r = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager connectionMgr = new PoolingHttpClientConnectionManager(r, null, null, null, (long)this.connectionPoolTimeToLive, TimeUnit.SECONDS);
        connectionMgr.setMaxTotal(this.maxConnectionsTotal);
        connectionMgr.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        HttpHost localhost = new HttpHost("localhost", 80);
        connectionMgr.setMaxPerRoute(new HttpRoute(localhost), this.maxConnectionsPerRoute);
        return connectionMgr;
    }

    private SSLContext buildSslContext() {
        SSLContext sslContext = null;
        try {
            SSLContextBuilder sslBuilder = this.sslContextBuilder;
            if (this.trustSelfSignCert) {
                sslBuilder = sslBuilder != null ? sslBuilder : SSLContexts.custom();
                sslBuilder.loadTrustMaterial((TrustStrategy)TrustSelfSignedMultiChainStrategy.INSTANCE);
            }
            if (this.keyStoreProvider != null) {
                KeyStore trustStore = this.keyStoreProvider.provide();
                sslBuilder = sslBuilder != null ? sslBuilder : SSLContexts.custom();
                sslBuilder.loadTrustMaterial(trustStore, null);
            }
            if (this.clientCertKeyStoreProvider != null && StringUtils.isNotBlank((String)this.clientCertAlias)) {
                sslBuilder = sslBuilder != null ? sslBuilder : SSLContexts.custom();
                KeyStore keyStore = this.clientCertKeyStoreProvider.provide();
                sslBuilder.loadKeyMaterial(keyStore, this.clientCertKeyStoreProvider.getPassword(), (aliases, socket) -> this.clientCertAlias);
            }
            if (sslBuilder != null) {
                sslContext = sslBuilder.build();
            }
        }
        catch (Exception e) {
            log.error("SSLContexts initiation has failed, " + e.getMessage());
        }
        return sslContext != null ? sslContext : SSLContexts.createDefault();
    }

    private boolean hasCredentials() {
        return this.credsProvider.getCredentials(AuthScope.ANY) != null;
    }

    public static class DefaultHostRoutePlanner
    extends DefaultRoutePlanner {
        private final HttpHost defaultHost;

        DefaultHostRoutePlanner(HttpHost defaultHost) {
            super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
            this.defaultHost = defaultHost;
        }

        public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
            if (host == null) {
                host = this.defaultHost;
            }
            return super.determineRoute(host, request, context);
        }

        public HttpHost getDefaultHost() {
            return this.defaultHost;
        }
    }

    protected static enum JFrogAuthScheme {
        BASIC,
        BEARER,
        SPNEGO;

    }

    public class ProxyConfigBuilder {
        private final String proxyHost;
        private final int proxyPort;
        Credentials creds;

        public ProxyConfigBuilder(String host, int port) {
            this.proxyHost = host;
            this.proxyPort = port;
            HttpBuilderBase.this.config.setProxy(new HttpHost(host, port));
        }

        public ProxyConfigBuilder authentication(String username, String password) {
            this.creds = new UsernamePasswordCredentials(username, password);
            List<String> authPrefs = Arrays.asList("Digest", "Basic", "NTLM");
            HttpBuilderBase.this.config.setProxyPreferredAuthSchemes(authPrefs);
            HttpBuilderBase.this.builder.addInterceptorFirst((HttpRequestInterceptor)new ProxyPreemptiveAuthInterceptor());
            this.setProxyCreds(this.proxyHost, this.proxyPort);
            return this;
        }

        public ProxyConfigBuilder ntlmAuthentication(String username, String password, String ntHost, String domain) {
            this.creds = new NTCredentials(username, password, ntHost, domain);
            HttpBuilderBase.this.builder.addInterceptorFirst((HttpRequestInterceptor)new ProxyPreemptiveAuthInterceptor());
            this.setProxyCreds(this.proxyHost, this.proxyPort);
            return this;
        }

        public ProxyConfigBuilder redirectToHostProxies(String[] hosts) {
            if (this.creds != null && hosts != null) {
                for (String hostName : hosts) {
                    this.setProxyCreds(hostName, this.proxyPort);
                }
            }
            return this;
        }

        private void setProxyCreds(String host, int port) {
            if (StringUtils.isBlank((String)this.proxyHost) || port == 0) {
                throw new IllegalStateException("Proxy host and port must be set before creating authentication");
            }
            HttpBuilderBase.this.credsProvider.setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM), this.creds);
        }
    }
}

