/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jfrog.client.http.CloseableObserver;
import org.jfrog.client.http.auth.KerberosAuthProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableHttpClientDecorator
extends CloseableHttpClient {
    private static final Logger log = LoggerFactory.getLogger(CloseableHttpClientDecorator.class);
    private final CloseableHttpClient closeableHttpClient;
    private final List<CloseableObserver> closeableObservers;
    private final KerberosAuthProvider kerberosAuthProvider;
    private final PoolingHttpClientConnectionManager clientConnectionManager;
    private final String id;
    private boolean clientClosed = false;
    private final RequestConfig defaultRequestConfig;

    public CloseableHttpClientDecorator(CloseableHttpClient closeableHttpClient, PoolingHttpClientConnectionManager clientConnectionManager, boolean useKerberos, RequestConfig requestConfig) {
        assert (closeableHttpClient != null) : "closeableHttpClient cannot be empty";
        assert (clientConnectionManager != null) : "clientConnectionManager cannot be empty";
        this.clientConnectionManager = clientConnectionManager;
        this.closeableObservers = Lists.newArrayList();
        this.closeableHttpClient = closeableHttpClient;
        this.kerberosAuthProvider = useKerberos ? new KerberosAuthProvider(closeableHttpClient) : null;
        this.id = this.generatePseudoUniqueId();
        this.defaultRequestConfig = requestConfig;
    }

    private String generatePseudoUniqueId() {
        return String.valueOf(System.currentTimeMillis()) + Thread.currentThread().getId() + ThreadLocalRandom.current().nextInt(10000);
    }

    public String getId() {
        return this.id;
    }

    public PoolingHttpClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void close() throws IOException {
        this.onClose();
        this.closeableHttpClient.close();
        this.clientClosed = true;
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return this.closeableHttpClient.execute(target, request, context);
    }

    @Deprecated
    public HttpParams getParams() {
        return this.closeableHttpClient.getParams();
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.closeableHttpClient.getConnectionManager();
    }

    public final CloseableHttpClient getDecorated() {
        return this.closeableHttpClient;
    }

    public final void registerCloseableObserver(CloseableObserver closeableObserver) {
        this.closeableObservers.add(closeableObserver);
    }

    public void onClose() {
        this.closeableObservers.forEach(o -> o.onObservedClose(this.getId()));
    }

    public CloseableHttpResponse executeKerberos(String principal, char[] password, HttpRequestBase request) throws IOException {
        log.trace("Executing kerberos password based request principal='{}', method='{}', url={}", new Object[]{principal, request.getMethod(), request.getURI()});
        return Optional.ofNullable(this.kerberosAuthProvider).orElseThrow(() -> new IOException("Kerberos authentication not supported by this client")).executeKerberos(principal, password, request);
    }

    public CloseableHttpResponse executeKerberos(String principal, String keyTabLocation, HttpRequestBase request) throws IOException {
        log.trace("Executing kerberos keytab based request principal='{}', method='{}', url={}", new Object[]{principal, request.getMethod(), request.getURI()});
        return Optional.ofNullable(this.kerberosAuthProvider).orElseThrow(() -> new IOException("Kerberos authentication not supported by this client")).executeKerberos(principal, keyTabLocation, request);
    }

    public RequestConfig getDefaultRequestConfig() {
        return this.defaultRequestConfig;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            if (!this.clientClosed) {
                this.closeableHttpClient.close();
                this.clientClosed = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

